@q file: READMEv1.1.w@>
\input "supp-pdf"
\input"/usr/local/yacco2/diagrams/o2mac.tex"
@** Comments on \Yacco2's |READMEv1.1| file --- Date: \today.\fbreak
\ptindent{Project: \Yacco2 --- Multi-threaded lr(1) Compiler/compiler system}
\ptindent{Distributed under license: Mozilla Public License, v. 2.0.}
\ptindent{Distribution Date: \today}
\ptindent{Distribution version: 1.1}
\ptindent{Comments: Currently for the Unix flavoured Platforms}
\ptindent{Author: Dave Bone}
\ptindent{Support email: cc.yacco2{\char 64}yahoo.ca}
\ptindent{Contributors list:}
\INDENT{.75in}{Dave Bone}
\fbreak
\fbreak
The distribution contains the programs: compiler/compiler {\it{\O2}} and its linker {\it{\O2linker}}, along
with its runtime library {\it{yacco2}}. There are build scripts for platforms: Apple, GNU, Solaris.
Various documents, grammars, reference manual, quality assurance suites, and generated c++ source code are included.
These items are elaborated upon further within this document.

@*2 License.\fbreak
\Yacco2's distributed source code is subject 
to the terms of the Mozilla Public License, v. 2.0. 
If a copy of the MPL was not distributed with this file, you can obtain one at http://mozilla.org/MPL/2.0/.
\fbreak
\fbreak
As best as I could, the ``Literate programming'' w type files 
contain a reference to this license along with their generated documents.
The c++ source files generated from the w files {\bf {do not and will not have any comments 
referencing this license but are also subject to its terms}}.
The {\it {ctangle}} program generating the c++ code does not emit programmer c type comments.
It emits ``\#line'' macro references to the  w file and only c comments to its gened document's section number.
Any discovered license omissions required to be referenced within \Yacco2's Project files
are still covered by this license and   
will be corrected in future distributions. 
\fbreak
\fbreak
@*2 Version |v1.1| --- minor fixes.\fbreak
\ptindent{\derives{} Regenerating Yacco2 c++ code emitted improper license comments that produced compile errors} 
\ptindent{\derives{} Renamed diagrams+etc folder to diagrams}


@*2 README literate programming.\fbreak
This ``READMEv1.1.w'' file is run thru the {\it cweave}
 progam to generate a tex file: cweave ``READMEv1.1.w''.
The {\bf{v1.1}} suffix in its name is the distribution's version.
Then the program {\it pdftex} is run to create its pdf document: pdftex ``READMEv1.1.tex''.
Literate programming at the install documentation level that u are now reading.
@*2 Comments on 1st attempt at ``Open Source''.\fbreak
Project \Yacco2{}   is my first attempt at ``Open Source'' software.
There are  propably faux pas made by my lack of experience but I'm willing to learn from the community.
My ears, eyes, and grey cells are open to your suggested refinements.
Harnessed non-determinism thru threading opens up parallel activities. The thought experiment stepping out 
with arbitration deciding multiple outcomes.
Interesting when a thread becomes  a computational universe having time displaying its trails of activities...
 

@*1 Some installation concerns.\fbreak
Here is a list of questions/answers to help u install and get things going.

@*2 How is \Yacco2 installed?.\fbreak
Grab a copy of the system and place it on your computer.
It comes as a zipped file named {\bf{yacco2.zip}}.
Depending on your run platform, either double click the zipped file
or run from the command-line-interface using an unzip program like gunzip.
Once unzipping its contents, the   {\bf{yacco2}} folder
contains subdirectories of text 
files aka grammars and ``literate programs'', the c++ source code, 
binary static libraries of \Yacco2, and the 2 executeable programs 
{\it o2} and {\it o2linker}
which are the compiler/compiler and its linker.

@*2 Where is \Yacco2 installed?.\fbreak
The {\bf{yacco2}} folder should be copied to the {\bf{/usr/local/}} folder.\fbreak
\fbreak
This distribution contains the executeables and libraries 
{\bf prebuilt for an Apple laptop running Maverick}. 
Other platforms will need to be built using the instructions below.
This comment also holds for older Apple platforms like the ``Cat'' series.

A ``drag and drop'' attitude it is to installing \Yacco2 
placed in {\bf{/usr/local/}}.
It is self contained. To thrown it out just drag
 the ``\Whereyacco2'' folder into the trash bin and delete it
or use the Unix ``rm'' utility to delete it.

For example if u unzipped \Yacco2 into your desktop folder, then 
the following {\it{Bash}} CLI move command on the Apple platform is:\fbreak
\ptindent{1) cd \char 126/DeskTop \# example Apple desktop holding yacco2 folder}
\ptindent{2) mv -f yacco2 /use/local/ \# move the yacco2 folder}
Substitute your own folder name containing yacco2 for the above ``cd'' command.
U can also use a ``drag-and-drop'' to do it.
For the Apple platform, u can unhide the hidden folders shown by ``Finder'' 
or use Finder's ``cmd-shift-G'' key combination and type in the
``/usr/local/'' to see its contents in the Finder's screen. 
Now ``drag-and-drop'' the {\bf{yacco2}} folder into {\bf{/usr/local/}}.
Other platforms have their version of ``drag-and-drop'' to move \Yacco2. 

@*2 What \Cpp{} compiler does it require to compile/install \Yacco2{} system?.\fbreak
The Apple environment needs Xcode or a  development system like GNU.
For the other platforms, a development system with a \Cpp{} compiler 
and a run time library supporting multi-threading.

This distribution already has the {\it o2} and {\it o2linker} programs installed along
with the {\it yacco2} library
for the latest Maverick Apple platform.
So u can stop the balance of the installation 
for the Apple if u are running Maverick.
For older Apple Operating systems like the ``Cat'' series, they require u to  do some adjustments
to the Apple scripts below. 
There are {\it bash} comments in these scripts on the variables to set.


@*2 How to install \Yacco2.\fbreak
Once you have placed \Yacco2{} system in {\bf ``/usr/local/''} on either your laptop or server, you will find
the following Bash scripts
where each script's suffix name indicates the platform to run the script under.\fbreak
\ptindent{1) bld\_bash\_APPLE}
\ptindent{2) bld\_bash\_GNU}
\ptindent{3) bld\_bash\_SOLARIS}
You run one of the above scripts with the {\it bash} command-line-interface(CLI).
Each script is documented with references to other scripts of {\bf makefile\_xxx} where xxx is
the platform to build
the subcomponents of \Yacco2. Have a read, they don't bite.

@*3 Possibly out-of-date --- GNU and Solaris scripts.\fbreak
Possibly points 2 + 3 could be out-of-date as I'm now developing exclusively on the Apple 
MacPro / Xcode environment. These scripts should clue u into what is
required to get them running on a more up-todate platform.
Once upon a time they worked but time has changed the Apple script and not them! 
So use the Apple script as a guide to get the other scripts working.
I'm sure the \Cpp{} compiler and its supporting libraries  will be out-of-date.

@*3 Run the installation script.\fbreak
Here are the bash commands to install the complete system on the Apple MacPro system:\fbreak
\ptindent{1) cd \Whereyacco2}
\ptindent{2) . |bld_bash_APPLE|}
The script has commented out other options that u can use for 
other things like gening the \Cweb{} files
to building debug executeables. Ditto on the other Operating system scripts.
\fbreak
\fbreak
{\bf Note}:
\fbreak
In the ./bin folder, there are the latest executeables for 
the Apple MacPro ``OS X 10.9.2’’/ Xcode 5.1.1: \O2{} and \O2linker
along with the libraries: {\it yacco2} in ``\Whereyacco2/library/lib/Release'' for u 
to link your own compiler to,
and {\it o2grammars} in ``\Whereyacco2/compiler/grammars/lib/Release'' 
for the \Yacco2{} programs to build against. 
Ready baked for u to try if u are on an Applelite.


@*3 Other OPs: GNU, SOLARIS for bld\_bash\_XXX and makefile\_XXX scripts.\fbreak
To provide consistency, scripts per run platform were written rather than
depend on a specific development framework like Apple's Xcode.
If u use a development framework, these scripts will clue u to the  ingredients needed to
map \Yacco2's components to your framework.
 
You will probably need {\bf to edit} the GNU or Solaris scripts regarding the C++
libraries versions needed.
The referenced {\bf makefile\_APPLE} scripts per subfolder 
like {\bf \Whereyacco2/library} in the {\bf bld\_bash\_APPLE} script 
uses the latest 64 bit LLVM compiler toolset under 
Apple's latest operating Maverick version ``10.9.2'' and {\bf Xcode} Version 5.1 (5B130a).
The later Xcode (6.+) versions were tried but at the time of preparing this distribution 
were unstable and crashing.
Possiblely now Xcode's latest version is stable but for now i'm staying with this earlier Xcode version.
Each {\bf makefile\_APPLE script per subfolder are up-todate} 
and can be run individually within their subfolder.
There are equivalent scripts to the mentioned APPLE scripts within the various folders
with suffix GNU or SOLARIS indicating the operating system supported.

Their use are the same under each operating platform.
For example to regenerate only the \Yacco2's library, run the following {\it bash} commands:\fbreak
\ptindent{1) cd \Whereyacco2/library}
\ptindent{2) make Genw -f makefile\_APPLE  \# gen c++ code from w files}
\ptindent{3) make Rlse -f makefile\_APPLE  \# compile c++ code and create library} 
All other port scripts {\bf should be eye-balled} against each {\it makefile\_APPLE} script 
for any adjustments needed when 
compiling/linking re: \Cpp{} compiler and {\bf ld} libraries used: {\it pthread}, {\it \Cpp}.
For the above example with the {\bf {\it Rlse}} parameter inputted, you will see it as a label within the bash script
with its appropriate compile and create the library commands.
These scripts are reasonably documented for your eyes and editing.\fbreak
\fbreak
{\bf Note:} the {\bf makefile\_APPLE} script can be modified to support an older {\bf Xcode}
version. \Yacco2{} has been developed on Xcode versions from 3 and greater
on Apple's ``Cat'' platforms.
You'll have to adjust your script for the appropriate \Cpp{} compiler 
and \Cpp{} runtime support library.

@*2 Grammar Testsuite.\fbreak
Added to the distribution in folder {\bf \Whereyacco2/grammar-testsuite} are some grammars   
from published papers
testing out lr(0), lr(1), and lalr ness by running its ``test-out-grammars.sh’’ {\it bash} script.
All platform scripts run \O2{} against the testsuite  to 
confirm the distribution validity.
It also runs self against self with one of its own grammars: ``eol.lex''.

@*3 A translator for your learnings from the Grammar Testsuite.\fbreak
To confirm that the distribution works, one of the published grammars: ``pager\_1.lex'' has a translator {\it {testout}}
that is compiled, linked against the built \Yacco2{} library, and run against some input with 
some  trace parameters turned on: see {\bf {1lrtracings.log}}.
Have a peek in its folder to see how easy it is to build a 
compiler/translator: script makefile\_testout\_APPLE..
Of course my leanings are towards ``literate programming'' use and hence the slant on its residues
of generated documents.

@*2 Quality Assurance.\fbreak
In {\bf {\Whereyacco2/qa}} folder, there are a series of batch files that tests 
out the ``quality assurance'' of \Yacco2.
Within the various tests are more grammars testing lr(1) compliance.
For the curious or doubters have a look or try them out yourself.
They might leave bite marks but should be a bit more convincing than my verbage.\fbreak
\ptindent{{\bf{cd \Whereyacco2/qa}}}
\ptindent{{\bf{ls *sh}} \# list of bash scripts to be run}

@*1 Challenge to the Open Source  / Computer Science Community.\fbreak
Depending on the \Cpp{} code, {\it cweave} emits unstructured code.
In the {\bf o2book} document there is a footnote as to why this is occuring.
I raise the challenge to u to correct this in improvements to the ``Open Source'' evolution.

Internet donations is a newer money raising model helping not-for-profit foundations 
with support staff
but for the majority of Open Source projects, their life expectancy becomes short lived
when others don't pick up the torch towards bug corrections etc.
Letting the author ``just do it'' leads to a no-growth attitude for the next generation.
Enough Dave of your squawking! 
So is the challenge taken up from possibly the computer science students as a class assignment? 
Let's hope  the future tales whisper challenge accepted/taken/completed!  

@*1 Unix {\it{man}}'s quick overview to \Yacco2's programs and API.\fbreak
In {\bf{\Whereyacco2/bin/man/man1}} are the Unix style references for:\fbreak
\ptindent{{\it{o2}} compiler/compiler}
\ptindent{{\it{o2linker}} \Yacco2's linker} 
\ptindent{{\it{yacco2}} API/library}
Either set up a link to this folder in your startup file like {\bf{.bash\_profile}} to exercise them,  
explicitly reference their path when running {\it{man}}, or adjust your {\bf{/private/etc/man.conf}} file.\fbreak
\fbreak
Command-line-interface examples for \Yacco2's references.\fbreak
The examples show variations 
 depending on how u set up the path reference:\fbreak
\ptindent{{\it{man}} \Whereyacco2/bin/man/man1/yacco2.1 \#explicit reference to API library}
\ptindent{{\it{man}} -M \Whereyacco2/bin/man/man1: yacco2 \# use man's path list}
\ptindent{{\it{man}} o2linker \# o2linker and man.conf file has \Yacco2's reference's link}
\ptindent{{\it{man}} o2 \# o2 where MANPATH has link}
  

@*1 Documents to read --- U have edocs Sir!.\fbreak
All docs are in the ``\Whereyacco2/docs'' folder in ``pdf'' format.\fbreak
\ptindent{1) Grammars in their published format --- examples of literate programming using \Cweb}
\ptindent{2) \O2's grammars in \Whereyacco2/compiler/grammars/*.lex in raw form.}
\ptindent{3) \O2{} and \O2linker{} documented source programs.}
\ptindent{4) wlibrary --- \Yacco2's documented library.}
\ptindent{5) Some unpublished essays --- p1, p2 discussing the why of \O2's language paradigm.}
\INDENT{1in}{Relatively relevent though early in \O2's development cycle.}
\ptindent{6) Unpublished Tugboat-o2 essay on ``literate programming'' as applied to \O2. A must read.}
\ptindent{7) Draft copy of reference ``o2book.pdf'' to rev u up.}
\ptindent{8) ``testout.pdf'' and grammars ``test*.pdf, pager\_1.pdf'' comments on writing your own compiler.}
\ptindent{9) ``testdriver.pdf'' and ``test\_components.pdf'' --- lexical quality assurance testing.}
\ptindent{10) possiblely published book --- ``\Yacco2 and some practical uses''.}

The unpublished essayes listed above should be read first as 
they describe in a light way the Why of \O2. For those that don't have time, at least speed read the
``Tugboat-o2'' essay.
{\it {testout}} program documentation should be read along with the ``o2book''.
There are comments to developing your own compiler regarding the Terminal / Error Vocabulary, and
Error tracing.
At least there are some clues/comments/references to \Yacco2{}, and  its use.

``\Yacco2 and some practical uses...'' will be a ``how to'' set of observations/steps  when i developed
a retargetting Pascal translator. It deals with observations made in grammars evolution, Terminal/Error Vocabulary 
development, symbol table management controlled from grammars' logic points, to 
tree building and their walkings within semantic routines.
The project's post evaluation gives observations, mistakes made,  and potential 
warnings  for your future language development.
Hopefully to u  a necessary companion with \Yacco2's reference ``o2book''.

@*1 Comments: Typesetting, ``Literate programming'', and Drawing.\fbreak
The principle software driving the typesetting 
of documents is \TeX{} which should be on your system.
Metapost is the graphics drawing system used to sketch grammars.
By combining the 2 components: \Cpp{} code and typesetting directives into one file, u now have
a ``Literate program''. This is the principle used by \O2's grammars.
\O2{} emits its own \Cpp{} code files.
For its grammar documents, \O2{} maps the grammar into a \Cweb's template form called 
 a ``literate grammar''
   and  also emits Metapost grammar type files.
These become the fodder for \Cweb's  {\it cweave} program  and Metapost's {\it mpost} digestion.
The \TeX{} {\it pdftex} program turns their outputed files into a pdf document.
All said, to use \O2{} does not require \TeX, \Cweb{} or Metapost systems to be installed but you are losing
out on one of the gems in \O2's tiarra: document generation.\fbreak
\fbreak
{\bf Caveat}: as the \Cweb{} system is required to emit \Cpp{} code from ``Literate programs'', all
of \Yacco2's programs and API library will be very difficult to modify/correct/enhance without this system installed.
\fbreak

Please go visit the {\bf {`www.tug.org'}} website.
It provides ``downloads'' for various operating platforms of  \TeX{}, \Cweb{}, and Metapost systems.
Other interesting software gems are there for download.
Accompanying these downloads are their ``How to use it'' manuals/documents.
{\bf Please consider joining Tug} as there are a lot of ``Open Source projects'' that need your support
to keep improving.\fbreak
A recap on programs  use:\fbreak
\ptindent{1) {\it cweave} creates a ``.tex'' file from a ``.w'' program for document creation.}
\ptindent{2) {\it pdftex} generates a pdf document from cweave's outputted `.tex' file.}
\ptindent{3) {\it ctangle} generates the \Cpp{} program from the same `.w' program.}
\ptindent{4) {\it mpost} is used to draw the grammar's productions generated from \O2.}
\fbreak
All \Yacco2's grammars and programs can be regenerated using these above programs. 
To generate the grammars's documents, they are run thru \O2 with the `-p' parameter
that  generates a `.w' file and accompanying mpost grammar diagrams for 
{\it mpost} and {\it cweave} digestion outputting the  ``.tex'' file 
for {\it pdftex}  to generate a ``pdf'' document.
Running \O2{} without or  with possible parameters  ``-t'', ``-err'' generates 
the ``.cpp'' files 
to be compiled by your \Cpp{} compiler.
\fbreak

@*2 Bash/batch files to help u do the dirty work.\fbreak
Have a look at `{\bf{o2grammars.sh}}’ bash script in `\Whereyacco2/compiler/grammars/' 
folder showing ``how to'' generate either a \Cpp{} or typeset document for each grammar.
`{\bf{gen1grammar.sh}}’ bash script  has the same capability but is applied to 1 interactively selected grammar.\fbreak
Here's how to gen your grammars.\fbreak
\ptindent{{\bf{cd /xxx}} \# your folder containing your grammar *.lex files}
\ptindent{{\bf{. \Whereyacco2{}/compiler/grammars/o2grammars.sh Rlse}} \# gen c++ code}
\ptindent{{\bf{cd /xxx}} \# your folder containing your grammar *.lex files}
\ptindent{{\bf{. \Whereyacco2{}/compiler/grammars/o2grammars.sh Genw}} \# gen grammar docs}
\ptindent{{\bf{mv *.pdf /xxx/docs}} \# optional: move docs from your grammars folder into your docs folder}

@*1 Potential problems installing \O2.\fbreak
This is a list of possible problems u might run across.
As the system gets more exposure / use, this list will probably grow.
Hopefully not too fast!

@*2 Why is \Yacco2{} installed at the  /usr/local level?.\fbreak
My 1st virtual attempt to get \Yacco2{} out to the ``Open Source Community'' and my laziness
had  it  installed at the root level but this has been changed.
``/usr/local'' was chosen as this seems to be the crowd's concensus to installing foreign
software.
I contemplated using Apple's ``Framwork'' approach but this seems
to be local to Apple though appropriate.
The original include statements for \Yacco2's library and API have been adjusted. 

@*2 File Permissions.\fbreak
After u installed the \Whereyacco2 folder make sure u can read / modify its contents.
chmod utility might be needed or by running the script suffixed to the  sudo utility.\fbreak
\ptindent{{\bf{chmod +a "staff allow read" \Whereyacco2}}}
 or \fbreak
\ptindent{{\bf{sudo chmod +a "staff allow read" \Whereyacco2}}}
 or \fbreak
\ptindent{{\bf{sudo chmod 755 \Whereyacco2}}}


 
@*2 Comments on compiling, linking, and \Cweb{} line macro referencing file's ``w'' code lines.\fbreak
Files makefile\_* like {\bf makefile\_APPLE} or {\bf makefile\_GNU} are found in \Whereyacco2's subfolders 
 of ``compiler/grammars/, compiler/o2/, 
library/, or o2linker/'' that compile the individual \Cpp{} programs and possibly  build a 
library, or create a runable program.
These {\it bash} scripts are Unix flavoured.
Cast your eyes on some of these files as the appropriate {\it bash} statements with comments
 show ``how to'' roll your own within these various Operating system contexts.
U should note the {\bf \Cpp's compiler options used}, and ditto
on the {\bf linker's parameters}.
They will clue u into what i needed to bootstrap \Yacco2{} onto 
different Operating system platforms.

In some of the subfolders you will find a {\it bash} script ``{\bf makefile\_Edit\_CWEB}'' to comment out
links to the CWEB code lines in the \Cpp{} generated programs. 
This is helpfull when u want to debug, set break points
to the \Cpp{} lines of code rather than the ``.w'' line of code
using your interactive debugger. 
Possibly the newer version of CWEB's {\bf ctangle} program has
an option whether to emit the ``c'' line macro or not. My version does not.
Hence the 
reason for the script to ``post process'' {\it ctangle}'s emitted C++ code. 
   
@*2 Where's libstdc$++$ or libc$++$ library?.\fbreak
{\bf Note}: The below points also apply to the other computer scripts: SOLARIS and GNU.\fbreak


These comments are more appropriate for older Xcode environments and other 
Unix platforms.
One problem u might experience is where does the libstdc$++$ library reside 
for building both programs \O2{} and \O2linker{} if u are
not using a development framework.
Or possibly u might want to use a different \Cpp{} compiler/set of libraries then the one
your system defaults to.
For an Apple computer, {\it bash} scripts ``{\bf \Whereyacco2/compiler/o2/makefile\_APPLE}'' 
and ``{\bf \Whereyacco2/o2linker/makefile\_APPLE}''
might need editing along with the c$++$ compiler to be used due to your older 
Xcode environment: eg. g$++$ or gcc compiler and libstdc$++$ library. 
Find out where the libstdc$++$ resides on your system.
Running these below {\it bash} commands to look for libstdc$++$  should 
find it. For other \Cpp{} library,  run the same commands below
with the appropriate library name to be searched:\fbreak
\ptindent{{\bf find /usr/ $\vert$ grep libstdc$++$}}
Or more general:\fbreak
\ptindent{{\bf find / $\vert$ grep libstdc$++$}}
Once found using your text editor, adjust the {\bf STDCC\_dir} variable 
with the found library location, the library {\bf CC\_lib} variable, 
and  compiler {\bf CC} variable
in the above 2 script files. The scripts are commented so u should not have any touble
editing them. 
Now rerun the {\it bash} script to rebuild \Yacco2:\fbreak
\ptindent{{\bf . bld\_bash\_APPLE}}


@*2 An inconvenience on getting the typesetting to work.\fbreak
An apology due to this minor inconvenience:  the ``{\bf cwebmac.tex}'' file might need to be modified
so that the grammar's file listings can be included into their generated documents.\fbreak
\fbreak
{\bf{Warning:}} Try generating a grammar document to see if your system needs to be adjusted.\fbreak
{\bf{Warning:}} The instructions are an example of what I had to do to get it working on my Apple laptop.\fbreak
{\bf{Warning:}} I am not responsible if they do not work covered by the license terms.\fbreak
\fbreak
{\it{
The below instructions are what I had to do to get it working on my Apple laptop.\fbreak
Please make appropriate backups before trying these instructions on your computer if required.
}}
\fbreak
\fbreak
To do this, u must find where the {\bf .../eplain/eplain.tex} file is 
installed on your computer from the Tex{} installation.
In my computer, it is in the folder  ``{\bf /usr/local/texlive/2014/texmf-dist/tex/eplain/eplain.tex}'' 
where the year of the distribution in this example is 2014 
which u would substitute with your own distribution year.
Possibly non Apple platforms could be distributed differently and would require you to use 
{\bf{its folder name instead of this example}}. 
Then u must edit ``{\bf .../cweb/cwebmac.tex}'' file from 
the \Cweb{} installation with the following
line added at the beginning of this file:\fbreak
\ptindent{{\bf$\backslash$input /usr/local/texlive/2014/texmf-dist/tex/eplain/eplain}}
On my computer this file is found here:\fbreak
\ptindent{{\bf /usr/local/texlive/2014/texmf-dist/tex/plain/cweb/cwebmac.tex}}
U can use your  prefered text editor but make sure u have write permission to this read-only file.
I used vim text editor with sudo to obtain write privileges.\fbreak
\ptindent{{\bf sudo vim /usr/local/texlive/2014/texmf-dist/tex/plain/cweb/cwebmac.tex}}
Here are its edited contents with my \TeX{}'s \% comments:\fbreak
\ptindent{{\bf \%\%\% Date: 23 Oct 2014 EDT modified cwebmac.tex file to fetch eplain tex macros}}
\ptindent{{\bf \%\%\% needed is the $\backslash$listing tex macro to generate grammar documents}}
\ptindent{{\bf $\backslash$input  /usr/local/texlive/2014/texmf-dist/tex/eplain/eplain}}
\fbreak

@*1 Happy \Yacco2{}ing.\fbreak
Bonne chance with your language development and use of \Yacco2.
 
@** Index.
