/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006!"}, d2={"Lcom/github/ajalt/colormath/LAB;", "Lcom/github/ajalt/colormath/Color;", "l", "", "a", "b", "alpha", "", "(DDDF)V", "getA", "()D", "getAlpha", "()F", "getB", "getL", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toLAB", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/XYZ;", "colormath"})
public final class LAB
implements Color {
    private final double l;
    private final double a;
    private final double b;
    private final float alpha;

    @Override
    @NotNull
    public RGB toRGB() {
        double d = this.l;
        return d == 0.0 ? new RGB(0, 0, 0, this.getAlpha()) : this.toXYZ().toRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        if (this.l == 0.0) {
            return new XYZ(0.0, 0.0, 0.0, 0.0f, 8, null);
        }
        double d = 0.20689655172413793;
        Function1<Double, Double> $fun$f$1 = new Function1<Double, Double>(d){
            final /* synthetic */ double $d;

            public final double invoke(double t) {
                double d;
                if (t > this.$d) {
                    double d2 = t;
                    int n = 3;
                    boolean bl = false;
                    d = Math.pow(d2, n);
                } else {
                    double d3 = this.$d;
                    int n = 2;
                    boolean bl = false;
                    d = (double)3 * Math.pow(d3, n) * (t - 0.13793103448275862);
                }
                return d;
            }
            {
                this.$d = d;
                super(1);
            }
        };
        double lp = (this.l + (double)16) / (double)116;
        double x = 0.95047 * $fun$f$1.invoke(lp + this.a / (double)500);
        double y = $fun$f$1.invoke(lp);
        double z = 1.08883 * $fun$f$1.invoke(lp - this.b / (double)200);
        return new XYZ(x * (double)100, y * (double)100, z * (double)100, this.getAlpha());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this;
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public LAB(double l, double a, double b, float alpha) {
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
        double d = this.l;
        boolean bl = d >= 0.0 && d <= 100.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "l must be in interval [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.getAlpha();
        boolean bl5 = f >= 0.0f && f <= 1.0f;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ LAB(double d, double d2, double d3, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        this(d, d2, d3, f);
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return Color.DefaultImpls.toHex(this, withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final float component4() {
        return this.getAlpha();
    }

    @NotNull
    public final LAB copy(double l, double a, double b, float alpha) {
        return new LAB(l, a, b, alpha);
    }

    public static /* synthetic */ LAB copy$default(LAB lAB, double d, double d2, double d3, float f, int n, Object object) {
        if ((n & 1) != 0) {
            d = lAB.l;
        }
        if ((n & 2) != 0) {
            d2 = lAB.a;
        }
        if ((n & 4) != 0) {
            d3 = lAB.b;
        }
        if ((n & 8) != 0) {
            f = lAB.getAlpha();
        }
        return lAB.copy(d, d2, d3, f);
    }

    @NotNull
    public String toString() {
        return "LAB(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.getAlpha() + ")";
    }

    public int hashCode() {
        return ((Double.hashCode(this.l) * 31 + Double.hashCode(this.a)) * 31 + Double.hashCode(this.b)) * 31 + Float.hashCode(this.getAlpha());
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LAB)) break block3;
                LAB lAB = (LAB)object;
                if (Double.compare(this.l, lAB.l) != 0 || Double.compare(this.a, lAB.a) != 0 || Double.compare(this.b, lAB.b) != 0 || Float.compare(this.getAlpha(), lAB.getAlpha()) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

