/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.components;

import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Renderable;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.SpanKt;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.ThemeKt;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.rendering.WidthRangeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\"\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u000f0\u0003j\u0002`\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u001a\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u000f0\u0003j\u0002`\u00102\u0006\u0010\u0013\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/ajalt/mordant/components/OrderedList;", "Lcom/github/ajalt/mordant/rendering/Renderable;", "listEntries", "", "numberStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "numberSeparator", "", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/TextStyle;Ljava/lang/String;)V", "maxBulletWidth", "", "bulletWidth", "i", "sepWidth", "continuationPadding", "Lcom/github/ajalt/mordant/rendering/Span;", "Lcom/github/ajalt/mordant/rendering/Line;", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "sep", "Lcom/github/ajalt/mordant/rendering/Theme;", "mordant"})
public final class OrderedList
implements Renderable {
    private final int maxBulletWidth;
    private final List<Renderable> listEntries;
    private final TextStyle numberStyle;
    private final String numberSeparator;

    private final List<Span> sep(Theme t) {
        List<Span> list;
        String string = this.numberSeparator;
        if (string == null) {
            string = t.getListNumberSeparator();
        }
        String text = string;
        boolean bl = !StringsKt.contains$default((CharSequence)text, "\n", false, 2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "number separator cannot contain newlines";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TextStyle textStyle = this.numberStyle;
        if (textStyle == null) {
            textStyle = t.getListNumber();
        }
        if ((list = CollectionsKt.firstOrNull(ParsingKt.parseText(text, textStyle).getLines())) == null) {
            list = LinesKt.getEMPTY_LINE();
        }
        return list;
    }

    private final List<Span> continuationPadding(int i, int sepWidth) {
        int n = this.bulletWidth(i, sepWidth);
        return CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, n, null, 2, null));
    }

    private final int bulletWidth(int i, int sepWidth) {
        double d = i + 1;
        boolean bl = false;
        return (int)Math.log10(d) + 1 + 2 + sepWidth;
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        return WidthRangeKt.maxWidthRange((Iterable<? extends Renderable>)this.listEntries, t, width, this.maxBulletWidth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        int contentWidth = width - this.maxBulletWidth;
        boolean bl = false;
        List lines = new ArrayList();
        TextStyle textStyle = this.numberStyle;
        if (textStyle == null) {
            textStyle = t.getTheme().getListNumber();
        }
        TextStyle style = textStyle;
        List<Span> sep = this.sep(t.getTheme());
        int sepWidth = LinesKt.getLineWidth(sep);
        boolean bl2 = false;
        for (Renderable entry : (Iterable)this.listEntries) {
            void i;
            List<Span> bullet = LinesKt.flatLine(SpanKt.getSINGLE_SPACE(), Span.Companion.word(String.valueOf((int)(i + true)), style), sep, SpanKt.getSINGLE_SPACE());
            boolean bl3 = false;
            for (List line : (Iterable)entry.render(t, contentWidth).getLines()) {
                void j;
                List<Span> start = j == false ? bullet : this.continuationPadding((int)i, sepWidth);
                Collection collection = lines;
                List list = CollectionsKt.plus((Collection)start, (Iterable)line);
                boolean bl4 = false;
                collection.add(list);
                ++j;
            }
            ++i;
        }
        return new Lines(lines);
    }

    public OrderedList(@NotNull List<? extends Renderable> listEntries, @Nullable TextStyle numberStyle, @Nullable String numberSeparator) {
        Intrinsics.checkNotNullParameter(listEntries, "listEntries");
        this.listEntries = listEntries;
        this.numberStyle = numberStyle;
        this.numberSeparator = numberSeparator;
        Collection collection = this.listEntries;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Cannot render an empty list";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxBulletWidth = this.bulletWidth(this.listEntries.size(), LinesKt.getLineWidth(this.sep(ThemeKt.getDEFAULT_THEME())));
    }

    public /* synthetic */ OrderedList(List list, TextStyle textStyle, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textStyle = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this(list, textStyle, string);
    }
}

