#ifndef _FILTER_H_
#define _FILTER_H_
#include "system.h"
#include "config.h"

#define F_OK 0
#define F_MEM_ERROR 1
#define F_BUF_ERROR 2
#define F_DATA_ERROR 3
#define F_UNKNOWN_ERROR 4
#define F_FILTER_UNKNOWN 5

#define F_AHx "ASCIIHexDecode"
#define F_A85 "ASCII85Decode"
#define F_LZW "LZWDecode"
#define F_Fl "FlateDecode"
#define F_RL "RunLengthDecode"
#define F_CCF "CCITTFaxDecode"
#define F_DCT "DCTDecode"

extern unsigned long decode_stream(char *dest, unsigned long destlen,
				   char *src, unsigned long srclen,
				   char *filter);
extern int decode_ahx (char *dest, unsigned long *destlen,
		       char *src, unsigned long srclen);
extern int decode_a85 (char *dest, unsigned long *destlen,
		       char *src, unsigned long srclen);
#ifdef HAVE_ZLIB
extern int decode_flate (char *dest, unsigned long *destlen,
			 char *src, unsigned long srclen);
#endif /* HAVE_ZLIB */
#endif /* _FILTER_H_ */
