/*
 * fg_teapot_data.h
 *
 * The freeglut library teapot data include file.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * PAWEL W. OLSZTA BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 * data derived from an archive uploaded by Juhana Kouhia, downloaded from:
 * ftp://ftp.funet.fi/pub/sci/graphics/packages/objects/teasetorig.gz
 * For all three parts of the teaset, the data has been scaled to match the
 * output of FreeGLUT's teapot and for the teacup and the teaspoon to be in
 * roughly appropriate size w.r.t. the teapot. Furthermore, unnecessary
 * control points have been removed from each object such that each cp is unique,
 * and by recognizing that many of the control points were simply rotated or
 * flipped version of others. For the teapot, a bottom has been added, while
 * vertices at the top of the teaspoon have been edited such that there is no
 * more gap.
 *
 * Juhana Kouhia received these models from Philip Schneider in 1990.
 * I have reproduced Philip's message below as it was found in the
 * teasetorig.gz archive, along with the original control points:

 From pjs@decpa.pa.dec.com Tue Feb 13 18:39:22 1990
 Received: from decpa.pa.dec.com by tut.fi; id AA06392; Tue, 13 Feb 90 18:38:31 +0200 
 Received: by decpa.pa.dec.com; id AA00959; Tue, 13 Feb 90 08:38:32 -0800
 Received: by basalt.pa.dec.com; id AA08467; Tue, 13 Feb 90 08:32:37 -0800
 Received: by bezier.pa.dec.com (5.57/Ultrix3.0-C)
 id AA12153; Tue, 13 Feb 90 08:34:52 -0800
 Date: Tue, 13 Feb 90 08:34:52 -0800
 From: pjs@decpa.pa.dec.com
 Message-Id: <9002131634.AA12153@bezier.pa.dec.com>
 To: jk87377@tut.fi
 Status: R

 Hi --

 Here's the data you requested.  Unfortunately, I have not found the data
 for the creamer, so it is not included.  The format is very simple.  The first
 line of each file is a comment describing what object is in the file.
 The second line are counts :

 #vertices	#objects	#patches	#patches

 Following this, there is a numbered list of vertices.  Following the
 vertices are, one per line, a list of indices of vertices, describing
 each patch.  The first index in each patch is preceded by the character
 "-" to delimit patch index lists.  The patches are all bicubic Bezier
 patches, so there are 16 vertices in each patch, and thus the vertex lists
 are each 16 entries long.  This is analogous to an "indexed polygon", if you
 are familiar with that format.

 The files follow below, delimited by two lines of "XXXXX".  Let me know
 if you have any problems understanding the format.

 - Philip Schneider
 pjs@decwrl.dec.com

 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

 Martin Newell's teapot made famous by J. Blinn (Bezier patches)
 269	1	28	28
 1  0.397163	0.638298	0
 2  0.397163	0.638298	-0.222411
 3  0.222411	0.638298	-0.397163
 4  0	0.638298	-0.397163
 5  0.379433	0.675532	0
 6  0.379433	0.675532	-0.212482
 7  0.212482	0.675532	-0.379433
 8  0	0.675532	-0.379433
 9  0.407801	0.675532	0
 10  0.407801	0.675532	-0.228369
 11  0.228369	0.675532	-0.407801
 12  0	0.675532	-0.407801
 13  0.425532	0.638298	0
 14  0.425532	0.638298	-0.238298
 15  0.238298	0.638298	-0.425532
 16  0	0.638298	-0.425532
 17  -0.222411	0.638298	-0.397163
 18  -0.397163	0.638298	-0.222411
 19  -0.397163	0.638298	0
 20  -0.212482	0.675532	-0.379433
 21  -0.379433	0.675532	-0.212482
 22  -0.379433	0.675532	0
 23  -0.228369	0.675532	-0.407801
 24  -0.407801	0.675532	-0.228369
 25  -0.407801	0.675532	0
 26  -0.238298	0.638298	-0.425532
 27  -0.425532	0.638298	-0.238298
 28  -0.425532	0.638298	0
 29  -0.397163	0.638298	0.222411
 30  -0.222411	0.638298	0.397163
 31  0	0.638298	0.397163
 32  -0.379433	0.675532	0.212482
 33  -0.212482	0.675532	0.379433
 34  0	0.675532	0.379433
 35  -0.407801	0.675532	0.228369
 36  -0.228369	0.675532	0.407801
 37  0	0.675532	0.407801
 38  -0.425532	0.638298	0.238298
 39  -0.238298	0.638298	0.425532
 40  0	0.638298	0.425532
 41  0.222411	0.638298	0.397163
 42  0.397163	0.638298	0.222411
 43  0.212482	0.675532	0.379433
 44  0.379433	0.675532	0.212482
 45  0.228369	0.675532	0.407801
 46  0.407801	0.675532	0.228369
 47  0.238298	0.638298	0.425532
 48  0.425532	0.638298	0.238298
 49  0.496454	0.489362	0
 50  0.496454	0.489362	-0.278014
 51  0.278014	0.489362	-0.496454
 52  0	0.489362	-0.496454
 53  0.567376	0.340426	0
 54  0.567376	0.340426	-0.31773
 55  0.31773	0.340426	-0.567376
 56  0	0.340426	-0.567376
 57  0.567376	0.212766	0
 58  0.567376	0.212766	-0.31773
 59  0.31773	0.212766	-0.567376
 60  0	0.212766	-0.567376
 61  -0.278014	0.489362	-0.496454
 62  -0.496454	0.489362	-0.278014
 63  -0.496454	0.489362	0
 64  -0.31773	0.340426	-0.567376
 65  -0.567376	0.340426	-0.31773
 66  -0.567376	0.340426	0
 67  -0.31773	0.212766	-0.567376
 68  -0.567376	0.212766	-0.31773
 69  -0.567376	0.212766	0
 70  -0.496454	0.489362	0.278014
 71  -0.278014	0.489362	0.496454
 72  0	0.489362	0.496454
 73  -0.567376	0.340426	0.31773
 74  -0.31773	0.340426	0.567376
 75  0	0.340426	0.567376
 76  -0.567376	0.212766	0.31773
 77  -0.31773	0.212766	0.567376
 78  0	0.212766	0.567376
 79  0.278014	0.489362	0.496454
 80  0.496454	0.489362	0.278014
 81  0.31773	0.340426	0.567376
 82  0.567376	0.340426	0.31773
 83  0.31773	0.212766	0.567376
 84  0.567376	0.212766	0.31773
 85  0.567376	0.0851064	0
 86  0.567376	0.0851064	-0.31773
 87  0.31773	0.0851064	-0.567376
 88  0	0.0851064	-0.567376
 89  0.425532	0.0212766	0
 90  0.425532	0.0212766	-0.238298
 91  0.238298	0.0212766	-0.425532
 92  0	0.0212766	-0.425532
 93  0.425532	0	0
 94  0.425532	0	-0.238298
 95  0.238298	0	-0.425532
 96  0	0	-0.425532
 97  -0.31773	0.0851064	-0.567376
 98  -0.567376	0.0851064	-0.31773
 99  -0.567376	0.0851064	0
 100  -0.238298	0.0212766	-0.425532
 101  -0.425532	0.0212766	-0.238298
 102  -0.425532	0.0212766	0
 103  -0.238298	0	-0.425532
 104  -0.425532	0	-0.238298
 105  -0.425532	0	0
 106  -0.567376	0.0851064	0.31773
 107  -0.31773	0.0851064	0.567376
 108  0	0.0851064	0.567376
 109  -0.425532	0.0212766	0.238298
 110  -0.238298	0.0212766	0.425532
 111  0	0.0212766	0.425532
 112  -0.425532	0	0.238298
 113  -0.238298	0	0.425532
 114  0	0	0.425532
 115  0.31773	0.0851064	0.567376
 116  0.567376	0.0851064	0.31773
 117  0.238298	0.0212766	0.425532
 118  0.425532	0.0212766	0.238298
 119  0.238298	0	0.425532
 120  0.425532	0	0.238298
 121  -0.453901	0.531915	0
 122  -0.453901	0.531915	-0.0851064
 123  -0.425532	0.595745	-0.0851064
 124  -0.425532	0.595745	0
 125  -0.652482	0.531915	0
 126  -0.652482	0.531915	-0.0851064
 127  -0.70922	0.595745	-0.0851064
 128  -0.70922	0.595745	0
 129  -0.765957	0.531915	0
 130  -0.765957	0.531915	-0.0851064
 131  -0.851064	0.595745	-0.0851064
 132  -0.851064	0.595745	0
 133  -0.765957	0.468085	0
 134  -0.765957	0.468085	-0.0851064
 135  -0.851064	0.468085	-0.0851064
 136  -0.851064	0.468085	0
 137  -0.425532	0.595745	0.0851064
 138  -0.453901	0.531915	0.0851064
 139  -0.70922	0.595745	0.0851064
 140  -0.652482	0.531915	0.0851064
 141  -0.851064	0.595745	0.0851064
 142  -0.765957	0.531915	0.0851064
 143  -0.851064	0.468085	0.0851064
 144  -0.765957	0.468085	0.0851064
 145  -0.765957	0.404255	0
 146  -0.765957	0.404255	-0.0851064
 147  -0.851064	0.340426	-0.0851064
 148  -0.851064	0.340426	0
 149  -0.70922	0.276596	0
 150  -0.70922	0.276596	-0.0851064
 151  -0.751773	0.223404	-0.0851064
 152  -0.751773	0.223404	0
 153  -0.567376	0.212766	-0.0851064
 154  -0.539007	0.12766	-0.0851064
 155  -0.539007	0.12766	0
 156  -0.851064	0.340426	0.0851064
 157  -0.765957	0.404255	0.0851064
 158  -0.751773	0.223404	0.0851064
 159  -0.70922	0.276596	0.0851064
 160  -0.539007	0.12766	0.0851064
 161  -0.567376	0.212766	0.0851064
 162  0.482269	0.361702	0
 163  0.482269	0.361702	-0.187234
 164  0.482269	0.12766	-0.187234
 165  0.482269	0.12766	0
 166  0.737589	0.361702	0
 167  0.737589	0.361702	-0.187234
 168  0.879433	0.191489	-0.187234
 169  0.879433	0.191489	0
 170  0.652482	0.553191	0
 171  0.652482	0.553191	-0.070922
 172  0.680851	0.531915	-0.070922
 173  0.680851	0.531915	0
 174  0.765957	0.638298	0
 175  0.765957	0.638298	-0.070922
 176  0.93617	0.638298	-0.070922
 177  0.93617	0.638298	0
 178  0.482269	0.12766	0.187234
 179  0.482269	0.361702	0.187234
 180  0.879433	0.191489	0.187234
 181  0.737589	0.361702	0.187234
 182  0.680851	0.531915	0.070922
 183  0.652482	0.553191	0.070922
 184  0.93617	0.638298	0.070922
 185  0.765957	0.638298	0.070922
 186  0.794326	0.659574	0
 187  0.794326	0.659574	-0.070922
 188  1	0.664894	-0.070922
 189  1	0.664894	0
 190  0.822695	0.659574	0
 191  0.822695	0.659574	-0.0425532
 192  0.978723	0.670213	-0.0425532
 193  0.978723	0.670213	0
 194  0.794326	0.638298	0
 195  0.794326	0.638298	-0.0425532
 196  0.907801	0.638298	-0.0425532
 197  0.907801	0.638298	0
 198  1	0.664894	0.070922
 199  0.794326	0.659574	0.070922
 200  0.978723	0.670213	0.0425532
 201  0.822695	0.659574	0.0425532
 202  0.907801	0.638298	0.0425532
 203  0.794326	0.638298	0.0425532
 204  0	0.851064	0
 205  0	0.851064	-0.000567376
 206  0.000567376	0.851064	0
 207  0.22695	0.851064	0
 208  0.22695	0.851064	-0.12766
 209  0.12766	0.851064	-0.22695
 210  0	0.851064	-0.22695
 211  0	0.765957	0
 212  0.0567376	0.723404	0
 213  0.0567376	0.723404	-0.031773
 214  0.031773	0.723404	-0.0567376
 215  0	0.723404	-0.0567376
 216  -0.000567376	0.851064	0
 217  -0.12766	0.851064	-0.22695
 218  -0.22695	0.851064	-0.12766
 219  -0.22695	0.851064	0
 220  -0.031773	0.723404	-0.0567376
 221  -0.0567376	0.723404	-0.031773
 222  -0.0567376	0.723404	0
 223  0	0.851064	0.000567376
 224  -0.22695	0.851064	0.12766
 225  -0.12766	0.851064	0.22695
 226  0	0.851064	0.22695
 227  -0.0567376	0.723404	0.031773
 228  -0.031773	0.723404	0.0567376
 229  0	0.723404	0.0567376
 230  0.12766	0.851064	0.22695
 231  0.22695	0.851064	0.12766
 232  0.031773	0.723404	0.0567376
 233  0.0567376	0.723404	0.031773
 234  0.113475	0.680851	0
 235  0.113475	0.680851	-0.0635461
 236  0.0635461	0.680851	-0.113475
 237  0	0.680851	-0.113475
 238  0.368794	0.680851	0
 239  0.368794	0.680851	-0.206525
 240  0.206525	0.680851	-0.368794
 241  0	0.680851	-0.368794
 242  0.368794	0.638298	0
 243  0.368794	0.638298	-0.206525
 244  0.206525	0.638298	-0.368794
 245  0	0.638298	-0.368794
 246  -0.0635461	0.680851	-0.113475
 247  -0.113475	0.680851	-0.0635461
 248  -0.113475	0.680851	0
 249  -0.206525	0.680851	-0.368794
 250  -0.368794	0.680851	-0.206525
 251  -0.368794	0.680851	0
 252  -0.206525	0.638298	-0.368794
 253  -0.368794	0.638298	-0.206525
 254  -0.368794	0.638298	0
 255  -0.113475	0.680851	0.0635461
 256  -0.0635461	0.680851	0.113475
 257  0	0.680851	0.113475
 258  -0.368794	0.680851	0.206525
 259  -0.206525	0.680851	0.368794
 260  0	0.680851	0.368794
 261  -0.368794	0.638298	0.206525
 262  -0.206525	0.638298	0.368794
 263  0	0.638298	0.368794
 264  0.0635461	0.680851	0.113475
 265  0.113475	0.680851	0.0635461
 266  0.206525	0.680851	0.368794
 267  0.368794	0.680851	0.206525
 268  0.206525	0.638298	0.368794
 269  0.368794	0.638298	0.206525
 -1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
 -4 17 18 19 8 20 21 22 12 23 24 25 16 26 27 28
 -19 29 30 31 22 32 33 34 25 35 36 37 28 38 39 40
 -31 41 42 1 34 43 44 5 37 45 46 9 40 47 48 13
 -13 14 15 16 49 50 51 52 53 54 55 56 57 58 59 60
 -16 26 27 28 52 61 62 63 56 64 65 66 60 67 68 69
 -28 38 39 40 63 70 71 72 66 73 74 75 69 76 77 78
 -40 47 48 13 72 79 80 49 75 81 82 53 78 83 84 57
 -57 58 59 60 85 86 87 88 89 90 91 92 93 94 95 96
 -60 67 68 69 88 97 98 99 92 100 101 102 96 103 104 105
 -69 76 77 78 99 106 107 108 102 109 110 111 105 112 113 114
 -78 83 84 57 108 115 116 85 111 117 118 89 114 119 120 93
 -121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136
 -124 137 138 121 128 139 140 125 132 141 142 129 136 143 144 133
 -133 134 135 136 145 146 147 148 149 150 151 152 69 153 154 155
 -136 143 144 133 148 156 157 145 152 158 159 149 155 160 161 69
 -162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177
 -165 178 179 162 169 180 181 166 173 182 183 170 177 184 185 174
 -174 175 176 177 186 187 188 189 190 191 192 193 194 195 196 197
 -177 184 185 174 189 198 199 186 193 200 201 190 197 202 203 194
 -204 205 206 204 207 208 209 210 211 211 211 211 212 213 214 215
 -204 216 205 204 210 217 218 219 211 211 211 211 215 220 221 222
 -204 223 216 204 219 224 225 226 211 211 211 211 222 227 228 229
 -204 206 223 204 226 230 231 207 211 211 211 211 229 232 233 212
 -212 213 214 215 234 235 236 237 238 239 240 241 242 243 244 245
 -215 220 221 222 237 246 247 248 241 249 250 251 245 252 253 254
 -222 227 228 229 248 255 256 257 251 258 259 260 254 261 262 263
 -229 232 233 212 257 264 265 234 260 266 267 238 263 268 269 242


 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

 Martin Newell's Teacup
 251	2	26	14
 1  0.409091	0.772727	0
 2  0.409091	0.772727	-0.229091
 3  0.229091	0.772727	-0.409091
 4  0	0.772727	-0.409091
 5  0.409091	0.886364	0
 6  0.409091	0.886364	-0.229091
 7  0.229091	0.886364	-0.409091
 8  0	0.886364	-0.409091
 9  0.454545	0.886364	0
 10  0.454545	0.886364	-0.254545
 11  0.254545	0.886364	-0.454545
 12  0	0.886364	-0.454545
 13  0.454545	0.772727	0
 14  0.454545	0.772727	-0.254545
 15  0.254545	0.772727	-0.454545
 16  0	0.772727	-0.454545
 17  -0.229091	0.772727	-0.409091
 18  -0.409091	0.772727	-0.229091
 19  -0.409091	0.772727	0
 20  -0.229091	0.886364	-0.409091
 21  -0.409091	0.886364	-0.229091
 22  -0.409091	0.886364	0
 23  -0.254545	0.886364	-0.454545
 24  -0.454545	0.886364	-0.254545
 25  -0.454545	0.886364	0
 26  -0.254545	0.772727	-0.454545
 27  -0.454545	0.772727	-0.254545
 28  -0.454545	0.772727	0
 29  -0.409091	0.772727	0.229091
 30  -0.229091	0.772727	0.409091
 31  0	0.772727	0.409091
 32  -0.409091	0.886364	0.229091
 33  -0.229091	0.886364	0.409091
 34  0	0.886364	0.409091
 35  -0.454545	0.886364	0.254545
 36  -0.254545	0.886364	0.454545
 37  0	0.886364	0.454545
 38  -0.454545	0.772727	0.254545
 39  -0.254545	0.772727	0.454545
 40  0	0.772727	0.454545
 41  0.229091	0.772727	0.409091
 42  0.409091	0.772727	0.229091
 43  0.229091	0.886364	0.409091
 44  0.409091	0.886364	0.229091
 45  0.254545	0.886364	0.454545
 46  0.454545	0.886364	0.254545
 47  0.254545	0.772727	0.454545
 48  0.454545	0.772727	0.254545
 49  0.454545	0.545455	0
 50  0.454545	0.545455	-0.254545
 51  0.254545	0.545455	-0.454545
 52  0	0.545455	-0.454545
 53  0.454545	0.272727	0
 54  0.454545	0.272727	-0.254545
 55  0.254545	0.272727	-0.454545
 56  0	0.272727	-0.454545
 57  0.318182	0.0454545	0
 58  0.318182	0.0454545	-0.178182
 59  0.178182	0.0454545	-0.318182
 60  0	0.0454545	-0.318182
 61  -0.254545	0.545455	-0.454545
 62  -0.454545	0.545455	-0.254545
 63  -0.454545	0.545455	0
 64  -0.254545	0.272727	-0.454545
 65  -0.454545	0.272727	-0.254545
 66  -0.454545	0.272727	0
 67  -0.178182	0.0454545	-0.318182
 68  -0.318182	0.0454545	-0.178182
 69  -0.318182	0.0454545	0
 70  -0.454545	0.545455	0.254545
 71  -0.254545	0.545455	0.454545
 72  0	0.545455	0.454545
 73  -0.454545	0.272727	0.254545
 74  -0.254545	0.272727	0.454545
 75  0	0.272727	0.454545
 76  -0.318182	0.0454545	0.178182
 77  -0.178182	0.0454545	0.318182
 78  0	0.0454545	0.318182
 79  0.254545	0.545455	0.454545
 80  0.454545	0.545455	0.254545
 81  0.254545	0.272727	0.454545
 82  0.454545	0.272727	0.254545
 83  0.178182	0.0454545	0.318182
 84  0.318182	0.0454545	0.178182
 85  0.545455	0.0454545	0
 86  0.545455	0.0454545	-0.305455
 87  0.305455	0.0454545	-0.545455
 88  0	0.0454545	-0.545455
 89  0.727273	0.136364	0
 90  0.727273	0.136364	-0.407273
 91  0.407273	0.136364	-0.727273
 92  0	0.136364	-0.727273
 93  0.909091	0.136364	0
 94  0.909091	0.136364	-0.509091
 95  0.509091	0.136364	-0.909091
 96  0	0.136364	-0.909091
 97  -0.305455	0.0454545	-0.545455
 98  -0.545455	0.0454545	-0.305455
 99  -0.545455	0.0454545	0
 100  -0.407273	0.136364	-0.727273
 101  -0.727273	0.136364	-0.407273
 102  -0.727273	0.136364	0
 103  -0.509091	0.136364	-0.909091
 104  -0.909091	0.136364	-0.509091
 105  -0.909091	0.136364	0
 106  -0.545455	0.0454545	0.305455
 107  -0.305455	0.0454545	0.545455
 108  0	0.0454545	0.545455
 109  -0.727273	0.136364	0.407273
 110  -0.407273	0.136364	0.727273
 111  0	0.136364	0.727273
 112  -0.909091	0.136364	0.509091
 113  -0.509091	0.136364	0.909091
 114  0	0.136364	0.909091
 115  0.305455	0.0454545	0.545455
 116  0.545455	0.0454545	0.305455
 117  0.407273	0.136364	0.727273
 118  0.727273	0.136364	0.407273
 119  0.509091	0.136364	0.909091
 120  0.909091	0.136364	0.509091
 121  1	0.136364	0
 122  1	0.136364	-0.56
 123  0.56	0.136364	-1
 124  0	0.136364	-1
 125  1	0.0909091	0
 126  1	0.0909091	-0.56
 127  0.56	0.0909091	-1
 128  0	0.0909091	-1
 129  0.909091	0.0909091	0
 130  0.909091	0.0909091	-0.509091
 131  0.509091	0.0909091	-0.909091
 132  0	0.0909091	-0.909091
 133  -0.56	0.136364	-1
 134  -1	0.136364	-0.56
 135  -1	0.136364	0
 136  -0.56	0.0909091	-1
 137  -1	0.0909091	-0.56
 138  -1	0.0909091	0
 139  -0.509091	0.0909091	-0.909091
 140  -0.909091	0.0909091	-0.509091
 141  -0.909091	0.0909091	0
 142  -1	0.136364	0.56
 143  -0.56	0.136364	1
 144  0	0.136364	1
 145  -1	0.0909091	0.56
 146  -0.56	0.0909091	1
 147  0	0.0909091	1
 148  -0.909091	0.0909091	0.509091
 149  -0.509091	0.0909091	0.909091
 150  0	0.0909091	0.909091
 151  0.56	0.136364	1
 152  1	0.136364	0.56
 153  0.56	0.0909091	1
 154  1	0.0909091	0.56
 155  0.509091	0.0909091	0.909091
 156  0.909091	0.0909091	0.509091
 157  0.727273	0.0909091	0
 158  0.727273	0.0909091	-0.407273
 159  0.407273	0.0909091	-0.727273
 160  0	0.0909091	-0.727273
 161  0.545455	0	0
 162  0.545455	0	-0.305455
 163  0.305455	0	-0.545455
 164  0	0	-0.545455
 165  0.318182	0	0
 166  0.318182	0	-0.178182
 167  0.178182	0	-0.318182
 168  0	0	-0.318182
 169  -0.407273	0.0909091	-0.727273
 170  -0.727273	0.0909091	-0.407273
 171  -0.727273	0.0909091	0
 172  -0.305455	0	-0.545455
 173  -0.545455	0	-0.305455
 174  -0.545455	0	0
 175  -0.178182	0	-0.318182
 176  -0.318182	0	-0.178182
 177  -0.318182	0	0
 178  -0.727273	0.0909091	0.407273
 179  -0.407273	0.0909091	0.727273
 180  0	0.0909091	0.727273
 181  -0.545455	0	0.305455
 182  -0.305455	0	0.545455
 183  0	0	0.545455
 184  -0.318182	0	0.178182
 185  -0.178182	0	0.318182
 186  0	0	0.318182
 187  0.407273	0.0909091	0.727273
 188  0.727273	0.0909091	0.407273
 189  0.305455	0	0.545455
 190  0.545455	0	0.305455
 191  0.178182	0	0.318182
 192  0.318182	0	0.178182
 193  0.272727	0.0454545	0
 194  0.272727	0.0454545	-0.152727
 195  0.152727	0.0454545	-0.272727
 196  0	0.0454545	-0.272727
 197  0.409091	0.272727	0
 198  0.409091	0.272727	-0.229091
 199  0.229091	0.272727	-0.409091
 200  0	0.272727	-0.409091
 201  0.409091	0.545455	0
 202  0.409091	0.545455	-0.229091
 203  0.229091	0.545455	-0.409091
 204  0	0.545455	-0.409091
 205  -0.152727	0.0454545	-0.272727
 206  -0.272727	0.0454545	-0.152727
 207  -0.272727	0.0454545	0
 208  -0.229091	0.272727	-0.409091
 209  -0.409091	0.272727	-0.229091
 210  -0.409091	0.272727	0
 211  -0.229091	0.545455	-0.409091
 212  -0.409091	0.545455	-0.229091
 213  -0.409091	0.545455	0
 214  -0.272727	0.0454545	0.152727
 215  -0.152727	0.0454545	0.272727
 216  0	0.0454545	0.272727
 217  -0.409091	0.272727	0.229091
 218  -0.229091	0.272727	0.409091
 219  0	0.272727	0.409091
 220  -0.409091	0.545455	0.229091
 221  -0.229091	0.545455	0.409091
 222  0	0.545455	0.409091
 223  0.152727	0.0454545	0.272727
 224  0.272727	0.0454545	0.152727
 225  0.229091	0.272727	0.409091
 226  0.409091	0.272727	0.229091
 227  0.229091	0.545455	0.409091
 228  0.409091	0.545455	0.229091
 229  -0.454545	0.704545	0
 230  -0.454545	0.704545	-0.0454545
 231  -0.454545	0.772727	-0.0454545
 232  -0.772727	0.863636	0
 233  -0.772727	0.863636	-0.0454545
 234  -0.818182	0.954545	-0.0454545
 235  -0.818182	0.954545	0
 236  -0.772727	0.522727	0
 237  -0.772727	0.522727	-0.0454545
 238  -0.909091	0.477273	-0.0454545
 239  -0.909091	0.477273	0
 240  -0.409091	0.363636	0
 241  -0.409091	0.363636	-0.0454545
 242  -0.409091	0.295455	-0.0454545
 243  -0.409091	0.295455	0
 244  -0.454545	0.772727	0.0454545
 245  -0.454545	0.704545	0.0454545
 246  -0.818182	0.954545	0.0454545
 247  -0.772727	0.863636	0.0454545
 248  -0.909091	0.477273	0.0454545
 249  -0.772727	0.522727	0.0454545
 250  -0.409091	0.295455	0.0454545
 251  -0.409091	0.363636	0.0454545
 -1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
 -4 17 18 19 8 20 21 22 12 23 24 25 16 26 27 28
 -19 29 30 31 22 32 33 34 25 35 36 37 28 38 39 40
 -31 41 42 1 34 43 44 5 37 45 46 9 40 47 48 13
 -13 14 15 16 49 50 51 52 53 54 55 56 57 58 59 60
 -16 26 27 28 52 61 62 63 56 64 65 66 60 67 68 69
 -28 38 39 40 63 70 71 72 66 73 74 75 69 76 77 78
 -40 47 48 13 72 79 80 49 75 81 82 53 78 83 84 57
 -193 194 195 196 197 198 199 200 201 202 203 204 1 2 3 4
 -196 205 206 207 200 208 209 210 204 211 212 213 4 17 18 19
 -207 214 215 216 210 217 218 219 213 220 221 222 19 29 30 31
 -216 223 224 193 219 225 226 197 222 227 228 201 31 41 42 1
 -229 230 231 28 232 233 234 235 236 237 238 239 240 241 242 243
 -28 244 245 229 235 246 247 232 239 248 249 236 243 250 251 240
 -57 58 59 60 85 86 87 88 89 90 91 92 93 94 95 96
 -60 67 68 69 88 97 98 99 92 100 101 102 96 103 104 105
 -69 76 77 78 99 106 107 108 102 109 110 111 105 112 113 114
 -78 83 84 57 108 115 116 85 111 117 118 89 114 119 120 93
 -93 94 95 96 121 122 123 124 125 126 127 128 129 130 131 132
 -96 103 104 105 124 133 134 135 128 136 137 138 132 139 140 141
 -105 112 113 114 135 142 143 144 138 145 146 147 141 148 149 150
 -114 119 120 93 144 151 152 121 147 153 154 125 150 155 156 129
 -129 130 131 132 157 158 159 160 161 162 163 164 165 166 167 168
 -132 139 140 141 160 169 170 171 164 172 173 174 168 175 176 177
 -141 148 149 150 171 178 179 180 174 181 182 183 177 184 185 186
 -150 155 156 129 180 187 188 157 183 189 190 161 186 191 192 165



 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

 Martin Newell's Teaspoon (bezier patches)
 256              1             16             16
 1  -0.000107143	0.205357	0
 2  0	0.196429	-0.0178571
 3  0	0.196429	-0.0178571
 4  0.000107143	0.205357	0
 5  -0.0535714	0.205357	0
 6  -0.0222714	0.178571	-0.0534286
 7  0.0222714	0.178571	-0.0534286
 8  0.0535714	0.205357	0
 9  -0.107143	0.0952429	-0.0178571
 10  -0.0446429	0.0952429	-0.0892857
 11  0.0446429	0.0952429	-0.0892857
 12  0.107143	0.0952429	-0.0178571
 13  -0.107143	0	-0.0178571
 14  -0.0446429	0	-0.0892857
 15  0.0446429	0	-0.0892857
 16  0.107143	0	-0.0178571
 17  0.000107143	0.205357	0
 18  0.000135714	0.207589	0.00446429
 19  0.000157143	0.216518	0.00446429
 20  0.000125	0.214286	0
 21  0.0535714	0.205357	0
 22  0.0613964	0.212054	0.0133571
 23  0.0714286	0.220982	0.015625
 24  0.0625	0.214286	0
 25  0.107143	0.0952429	-0.0178571
 26  0.122768	0.0952429	0
 27  0.142857	0.0952429	0.00446429
 28  0.125	0.0952429	-0.0178571
 29  0.107143	0	-0.0178571
 30  0.122768	0	0
 31  0.142857	0	0.00446429
 32  0.125	0	-0.0178571
 33  0.000125	0.214286	0
 34  0	0.205357	-0.0178571
 35  0	0.205357	-0.0178571
 36  -0.000125	0.214286	0
 37  0.0625	0.214286	0
 38  0.0267857	0.1875	-0.0625
 39  -0.0267857	0.1875	-0.0625
 40  -0.0625	0.214286	0
 41  0.125	0.0952429	-0.0178571
 42  0.0535714	0.0952429	-0.107143
 43  -0.0535714	0.0952429	-0.107143
 44  -0.125	0.0952429	-0.0178571
 45  0.125	0	-0.0178571
 46  0.0535714	0	-0.107143
 47  -0.0535714	0	-0.107143
 48  -0.125	0	-0.0178571
 49  -0.000125	0.214286	0
 50  -0.000157143	0.216518	0.00446429
 51  -0.000135714	0.207589	0.00446429
 52  -0.000107143	0.205357	0
 53  -0.0625	0.214286	0
 54  -0.0714286	0.220982	0.015625
 55  -0.0613964	0.212054	0.0133571
 56  -0.0535714	0.205357	0
 57  -0.125	0.0952429	-0.0178571
 58  -0.142857	0.0952429	0.00446429
 59  -0.122768	0.0952429	0
 60  -0.107143	0.0952429	-0.0178571
 61  -0.125	0	-0.0178571
 62  -0.142857	0	0.00446429
 63  -0.122768	0	0
 64  -0.107143	0	-0.0178571
 65  -0.107143	0	-0.0178571
 66  -0.0446429	0	-0.0892857
 67  0.0446429	0	-0.0892857
 68  0.107143	0	-0.0178571
 69  -0.107143	-0.142857	-0.0178571
 70  -0.0446429	-0.142857	-0.0892857
 71  0.0446429	-0.142857	-0.0892857
 72  0.107143	-0.142857	-0.0178571
 73  -0.0133929	-0.160714	0.0386893
 74  -0.00557857	-0.160714	0.0386893
 75  0.00557857	-0.160714	0.0386893
 76  0.0133929	-0.160714	0.0386893
 77  -0.0133929	-0.25	0.0535714
 78  -0.00557857	-0.25	0.0535714
 79  0.00557857	-0.25	0.0535714
 80  0.0133929	-0.25	0.0535714
 81  0.107143	0	-0.0178571
 82  0.122768	0	0
 83  0.142857	0	0.00446429
 84  0.125	0	-0.0178571
 85  0.107143	-0.142857	-0.0178571
 86  0.122768	-0.142857	0
 87  0.142857	-0.142857	0.00446429
 88  0.125	-0.142857	-0.0178571
 89  0.0133929	-0.160714	0.0386893
 90  0.0153464	-0.160714	0.0386893
 91  0.0178571	-0.160714	0.0314357
 92  0.015625	-0.160714	0.0297607
 93  0.0133929	-0.25	0.0535714
 94  0.0153464	-0.25	0.0535714
 95  0.0178571	-0.25	0.0463179
 96  0.015625	-0.25	0.0446429
 97  0.125	0	-0.0178571
 98  0.0535714	0	-0.107143
 99  -0.0535714	0	-0.107143
 100  -0.125	0	-0.0178571
 101  0.125	-0.142857	-0.0178571
 102  0.0535714	-0.142857	-0.107143
 103  -0.0535714	-0.142857	-0.107143
 104  -0.125	-0.142857	-0.0178571
 105  0.015625	-0.160714	0.0297607
 106  0.00669643	-0.160714	0.0230643
 107  -0.00781071	-0.160714	0.0208321
 108  -0.015625	-0.160714	0.0297607
 109  0.015625	-0.25	0.0446429
 110  0.00669643	-0.25	0.0379464
 111  -0.00781071	-0.25	0.0357143
 112  -0.015625	-0.25	0.0446429
 113  -0.125	0	-0.0178571
 114  -0.142857	0	0.00446429
 115  -0.122768	0	0
 116  -0.107143	0	-0.0178571
 117  -0.125	-0.142857	-0.0178571
 118  -0.142857	-0.142857	0.00446429
 119  -0.122768	-0.142857	0
 120  -0.107143	-0.142857	-0.0178571
 121  -0.015625	-0.160714	0.0297607
 122  -0.0175786	-0.160714	0.0319929
 123  -0.0153464	-0.160714	0.0386893
 124  -0.0133929	-0.160714	0.0386893
 125  -0.015625	-0.25	0.0446429
 126  -0.0175786	-0.25	0.046875
 127  -0.0153464	-0.25	0.0535714
 128  -0.0133929	-0.25	0.0535714
 129  -0.0133929	-0.25	0.0535714
 130  -0.00557857	-0.25	0.0535714
 131  0.00557857	-0.25	0.0535714
 132  0.0133929	-0.25	0.0535714
 133  -0.0133929	-0.46425	0.0892857
 134  -0.00557857	-0.46425	0.0892857
 135  0.00557857	-0.46425	0.0892857
 136  0.0133929	-0.46425	0.0892857
 137  -0.0446429	-0.678571	0.0535714
 138  -0.00892857	-0.678571	0.0625
 139  0.00892857	-0.678571	0.0625
 140  0.0446429	-0.678571	0.0535714
 141  -0.0446429	-0.857143	0.0357143
 142  -0.00892857	-0.857143	0.0446429
 143  0.00892857	-0.857143	0.0446429
 144  0.0446429	-0.857143	0.0357143
 145  0.0133929	-0.25	0.0535714
 146  0.0153464	-0.25	0.0535714
 147  0.0178571	-0.25	0.0463179
 148  0.015625	-0.25	0.0446429
 149  0.0133929	-0.46425	0.0892857
 150  0.0153464	-0.464286	0.0892857
 151  0.0178571	-0.46425	0.0820321
 152  0.015625	-0.46425	0.0803571
 153  0.0446429	-0.678571	0.0535714
 154  0.0535714	-0.678571	0.0513393
 155  0.0535714	-0.678571	0.0334821
 156  0.0446429	-0.678571	0.0357143
 157  0.0446429	-0.857143	0.0357143
 158  0.0535714	-0.857143	0.0334821
 159  0.0535714	-0.857143	0.015625
 160  0.0446429	-0.857143	0.0178571
 161  0.015625	-0.25	0.0446429
 162  0.00669643	-0.25	0.0379464
 163  -0.00781071	-0.25	0.0357143
 164  -0.015625	-0.25	0.0446429
 165  0.015625	-0.46425	0.0803571
 166  0.00669643	-0.464286	0.0736607
 167  -0.00781071	-0.46425	0.0714286
 168  -0.015625	-0.46425	0.0803571
 169  0.0446429	-0.678571	0.0357143
 170  0.00892857	-0.678571	0.0446429
 171  -0.00892857	-0.678571	0.0446429
 172  -0.0446429	-0.678571	0.0357143
 173  0.0446429	-0.857143	0.0178571
 174  0.00892857	-0.857143	0.0267857
 175  -0.00892857	-0.857143	0.0267857
 176  -0.0446429	-0.857143	0.0178571
 177  -0.015625	-0.25	0.0446429
 178  -0.0175786	-0.25	0.046875
 179  -0.0153464	-0.25	0.0535714
 180  -0.0133929	-0.25	0.0535714
 181  -0.015625	-0.46425	0.0803571
 182  -0.0175786	-0.464286	0.0825893
 183  -0.0153464	-0.464286	0.0892857
 184  -0.0133929	-0.46425	0.0892857
 185  -0.0446429	-0.678571	0.0357143
 186  -0.0535714	-0.678571	0.0334821
 187  -0.0535714	-0.678571	0.0513393
 188  -0.0446429	-0.678571	0.0535714
 189  -0.0446429	-0.857143	0.0178571
 190  -0.0535714	-0.857143	0.015625
 191  -0.0535714	-0.857143	0.0334821
 192  -0.0446429	-0.857143	0.0357143
 193  -0.0446429	-0.857143	0.0357143
 194  -0.00892857	-0.857143	0.0446429
 195  0.00892857	-0.857143	0.0446429
 196  0.0446429	-0.857143	0.0357143
 197  -0.0446429	-0.928571	0.0285714
 198  -0.00892857	-0.928571	0.0375
 199  0.00892857	-0.928571	0.0375
 200  0.0446429	-0.928571	0.0285714
 201  -0.0539286	-0.999643	0.0178571
 202  0.000357143	-0.999643	0.0178571
 203  0	-0.999643	0.0178571
 204  0.0535714	-0.999643	0.0178571
 205  -0.000357143	-1	0.0178571
 206  0.000357143	-1	0.0178571
 207  0	-1	0.0178571
 208  0	-1	0.0178571
 209  0.0446429	-0.857143	0.0357143
 210  0.0535714	-0.857143	0.0334821
 211  0.0535714	-0.857143	0.015625
 212  0.0446429	-0.857143	0.0178571
 213  0.0446429	-0.928571	0.0285714
 214  0.0535714	-0.928571	0.0263393
 215  0.0535714	-0.928571	0.00848214
 216  0.0446429	-0.928571	0.0107143
 217  0.0535714	-0.999643	0.0178571
 218  0.0669643	-0.999643	0.0178571
 219  0.0673214	-0.999643	0
 220  0.0539286	-0.999643	0
 221  0	-1	0.0178571
 222  0	-1	0.0178571
 223  0.000357143	-1	0
 224  0.000357143	-1	0
 225  0.0446429	-0.857143	0.0178571
 226  0.00892857	-0.857143	0.0267857
 227  -0.00892857	-0.857143	0.0267857
 228  -0.0446429	-0.857143	0.0178571
 229  0.0446429	-0.928571	0.0107143
 230  0.00892857	-0.928571	0.0196429
 231  -0.00892857	-0.928571	0.0196429
 232  -0.0446429	-0.928571	0.0107143
 233  0.0539286	-0.999643	0
 234  0.000357143	-0.999643	0
 235  -0.000357143	-0.999643	0
 236  -0.0539286	-0.999643	0
 237  0.000357143	-1	0
 238  0.000357143	-1	0
 239  -0.000357143	-1	0
 240  -0.000357143	-1	0
 241  -0.0446429	-0.857143	0.0178571
 242  -0.0535714	-0.857143	0.015625
 243  -0.0535714	-0.857143	0.0334821
 244  -0.0446429	-0.857143	0.0357143
 245  -0.0446429	-0.928571	0.0107143
 246  -0.0535714	-0.928571	0.00848214
 247  -0.0535714	-0.928571	0.0263393
 248  -0.0446429	-0.928571	0.0285714
 249  -0.0539286	-0.999643	0
 250  -0.0673214	-0.999643	0
 251  -0.0675	-0.999643	0.0178571
 252  -0.0539286	-0.999643	0.0178571
 253  -0.000357143	-1	0
 254  -0.000357143	-1	0
 255  -0.000535714	-1	0.0178571
 256  -0.000357143	-1	0.0178571
 -1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
 -17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32
 -33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48
 -49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64
 -65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80
 -81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96
 -97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112
 -113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128
 -129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144
 -145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160
 -161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176
 -177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192
 -193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208
 -209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224
 -225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240
 -241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256


 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


 Jim Blinn's doughnout (used in III table top scene) bezier patches
 [snip]

 */

#ifndef  FREEGLUT_TEAPOT_DATA_H
#define  FREEGLUT_TEAPOT_DATA_H

/*
 * Rim, body, lid, and bottom data must be rotated along all four quadrants;
 * handle and spout data is flipped across the x-y plane (negate z values) only.
 */
#define GLUT_TEAPOT_N_INPUT_PATCHES 10
static int patchdata_teapot[GLUT_TEAPOT_N_INPUT_PATCHES][16] =
{
    {  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, }, /* rim    */
    { 12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27, }, /* body   */
    { 24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39, },
    { 40,  41,  42,  40,  43,  44,  45,  46,  47,  47,  47,  47,  48,  49,  50,  51, }, /* lid    */
    { 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, },
    { 64,  64,  64,  64,  65,  66,  67,  68,  69,  70,  71,  72,  39,  38,  37,  36, }, /* bottom */
    { 73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88, }, /* handle */
    { 85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99, 100, },
    {101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, }, /* spout  */
    {113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128  }
};

static GLfloat cpdata_teapot[][3] =
{
    { 1.40000f,  0.00000f,  2.40000f}, { 1.40000f, -0.78400f,  2.40000f},
    { 0.78400f, -1.40000f,  2.40000f}, { 0.00000f, -1.40000f,  2.40000f},
    { 1.33750f,  0.00000f,  2.53125f}, { 1.33750f, -0.74900f,  2.53125f},
    { 0.74900f, -1.33750f,  2.53125f}, { 0.00000f, -1.33750f,  2.53125f},
    { 1.43750f,  0.00000f,  2.53125f}, { 1.43750f, -0.80500f,  2.53125f},
    { 0.80500f, -1.43750f,  2.53125f}, { 0.00000f, -1.43750f,  2.53125f},
    { 1.50000f,  0.00000f,  2.40000f}, { 1.50000f, -0.84000f,  2.40000f},
    { 0.84000f, -1.50000f,  2.40000f}, { 0.00000f, -1.50000f,  2.40000f},
    { 1.75000f,  0.00000f,  1.87500f}, { 1.75000f, -0.98000f,  1.87500f},
    { 0.98000f, -1.75000f,  1.87500f}, { 0.00000f, -1.75000f,  1.87500f},
    { 2.00000f,  0.00000f,  1.35000f}, { 2.00000f, -1.12000f,  1.35000f},
    { 1.12000f, -2.00000f,  1.35000f}, { 0.00000f, -2.00000f,  1.35000f},
    { 2.00000f,  0.00000f,  0.90000f}, { 2.00000f, -1.12000f,  0.90000f},
    { 1.12000f, -2.00000f,  0.90000f}, { 0.00000f, -2.00000f,  0.90000f},
    { 2.00000f,  0.00000f,  0.45000f}, { 2.00000f, -1.12000f,  0.45000f},
    { 1.12000f, -2.00000f,  0.45000f}, { 0.00000f, -2.00000f,  0.45000f},
    { 1.50000f,  0.00000f,  0.22500f}, { 1.50000f, -0.84000f,  0.22500f},
    { 0.84000f, -1.50000f,  0.22500f}, { 0.00000f, -1.50000f,  0.22500f},
    { 1.50000f,  0.00000f,  0.15000f}, { 1.50000f, -0.84000f,  0.15000f},
    { 0.84000f, -1.50000f,  0.15000f}, { 0.00000f, -1.50000f,  0.15000f},
    { 0.00000f,  0.00000f,  3.15000f}, { 0.00000f, -0.00200f,  3.15000f},
    { 0.00200f,  0.00000f,  3.15000f}, { 0.80000f,  0.00000f,  3.15000f},
    { 0.80000f, -0.45000f,  3.15000f}, { 0.45000f, -0.80000f,  3.15000f},
    { 0.00000f, -0.80000f,  3.15000f}, { 0.00000f,  0.00000f,  2.85000f},
    { 0.20000f,  0.00000f,  2.70000f}, { 0.20000f, -0.11200f,  2.70000f},
    { 0.11200f, -0.20000f,  2.70000f}, { 0.00000f, -0.20000f,  2.70000f},
    { 0.40000f,  0.00000f,  2.55000f}, { 0.40000f, -0.22400f,  2.55000f},
    { 0.22400f, -0.40000f,  2.55000f}, { 0.00000f, -0.40000f,  2.55000f},
    { 1.30000f,  0.00000f,  2.55000f}, { 1.30000f, -0.72800f,  2.55000f},
    { 0.72800f, -1.30000f,  2.55000f}, { 0.00000f, -1.30000f,  2.55000f},
    { 1.30000f,  0.00000f,  2.40000f}, { 1.30000f, -0.72800f,  2.40000f},
    { 0.72800f, -1.30000f,  2.40000f}, { 0.00000f, -1.30000f,  2.40000f},
    { 0.00000f,  0.00000f,  0.00000f}, { 0.00000f, -1.42500f,  0.00000f},
    { 0.79800f, -1.42500f,  0.00000f}, { 1.42500f, -0.79800f,  0.00000f},
    { 1.42500f,  0.00000f,  0.00000f}, { 0.00000f, -1.50000f,  0.07500f},
    { 0.84000f, -1.50000f,  0.07500f}, { 1.50000f, -0.84000f,  0.07500f},
    { 1.50000f,  0.00000f,  0.07500f}, {-1.60000f,  0.00000f,  2.02500f},
    {-1.60000f, -0.30000f,  2.02500f}, {-1.50000f, -0.30000f,  2.25000f},
    {-1.50000f,  0.00000f,  2.25000f}, {-2.30000f,  0.00000f,  2.02500f},
    {-2.30000f, -0.30000f,  2.02500f}, {-2.50000f, -0.30000f,  2.25000f},
    {-2.50000f,  0.00000f,  2.25000f}, {-2.70000f,  0.00000f,  2.02500f},
    {-2.70000f, -0.30000f,  2.02500f}, {-3.00000f, -0.30000f,  2.25000f},
    {-3.00000f,  0.00000f,  2.25000f}, {-2.70000f,  0.00000f,  1.80000f},
    {-2.70000f, -0.30000f,  1.80000f}, {-3.00000f, -0.30000f,  1.80000f},
    {-3.00000f,  0.00000f,  1.80000f}, {-2.70000f,  0.00000f,  1.57500f},
    {-2.70000f, -0.30000f,  1.57500f}, {-3.00000f, -0.30000f,  1.35000f},
    {-3.00000f,  0.00000f,  1.35000f}, {-2.50000f,  0.00000f,  1.12500f},
    {-2.50000f, -0.30000f,  1.12500f}, {-2.65000f, -0.30000f,  0.93750f},
    {-2.65000f,  0.00000f,  0.93750f}, {-2.00000f,  0.00000f,  0.90000f},
    {-2.00000f, -0.30000f,  0.90000f}, {-1.90000f, -0.30000f,  0.60000f},
    {-1.90000f,  0.00000f,  0.60000f}, { 1.70000f,  0.00000f,  1.42500f},
    { 1.70000f, -0.66000f,  1.42500f}, { 1.70000f, -0.66000f,  0.60000f},
    { 1.70000f,  0.00000f,  0.60000f}, { 2.60000f,  0.00000f,  1.42500f},
    { 2.60000f, -0.66000f,  1.42500f}, { 3.10000f, -0.66000f,  0.82500f},
    { 3.10000f,  0.00000f,  0.82500f}, { 2.30000f,  0.00000f,  2.10000f},
    { 2.30000f, -0.25000f,  2.10000f}, { 2.40000f, -0.25000f,  2.02500f},
    { 2.40000f,  0.00000f,  2.02500f}, { 2.70000f,  0.00000f,  2.40000f},
    { 2.70000f, -0.25000f,  2.40000f}, { 3.30000f, -0.25000f,  2.40000f},
    { 3.30000f,  0.00000f,  2.40000f}, { 2.80000f,  0.00000f,  2.47500f},
    { 2.80000f, -0.25000f,  2.47500f}, { 3.52500f, -0.25000f,  2.49375f},
    { 3.52500f,  0.00000f,  2.49375f}, { 2.90000f,  0.00000f,  2.47500f},
    { 2.90000f, -0.15000f,  2.47500f}, { 3.45000f, -0.15000f,  2.51250f},
    { 3.45000f,  0.00000f,  2.51250f}, { 2.80000f,  0.00000f,  2.40000f},
    { 2.80000f, -0.15000f,  2.40000f}, { 3.20000f, -0.15000f,  2.40000f},
    { 3.20000f,  0.00000f,  2.40000f}
};

#define GLUT_TEACUP_N_INPUT_PATCHES 7
static int patchdata_teacup[GLUT_TEACUP_N_INPUT_PATCHES][16] =
{
    {  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15, }, /* like teapot, first 6 are rotated along all four quadrants */
    { 12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27, },
    { 28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,   0,   1,   2,   3, },
    { 24,  25,  26,  27,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51, },
    { 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, },
    { 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75, },
    { 76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91  } /* this one is flipped once */
};

static GLfloat cpdata_teacup[][3] =
{
    { 1.44205f,  0.00000f,  2.72386f}, { 1.44205f, -0.80755f,  2.72386f},
    { 0.80755f, -1.44205f,  2.72386f}, { 0.00000f, -1.44205f,  2.72386f},
    { 1.44205f,  0.00000f,  3.12443f}, { 1.44205f, -0.80755f,  3.12443f},
    { 0.80755f, -1.44205f,  3.12443f}, { 0.00000f, -1.44205f,  3.12443f},
    { 1.60227f,  0.00000f,  3.12443f}, { 1.60227f, -0.89727f,  3.12443f},
    { 0.89727f, -1.60227f,  3.12443f}, { 0.00000f, -1.60227f,  3.12443f},
    { 1.60227f,  0.00000f,  2.72386f}, { 1.60227f, -0.89727f,  2.72386f},
    { 0.89727f, -1.60227f,  2.72386f}, { 0.00000f, -1.60227f,  2.72386f},
    { 1.60227f,  0.00000f,  1.92273f}, { 1.60227f, -0.89727f,  1.92273f},
    { 0.89727f, -1.60227f,  1.92273f}, { 0.00000f, -1.60227f,  1.92273f},
    { 1.60227f,  0.00000f,  0.96136f}, { 1.60227f, -0.89727f,  0.96136f},
    { 0.89727f, -1.60227f,  0.96136f}, { 0.00000f, -1.60227f,  0.96136f},
    { 1.12159f,  0.00000f,  0.16023f}, { 1.12159f, -0.62809f,  0.16023f},
    { 0.62809f, -1.12159f,  0.16023f}, { 0.00000f, -1.12159f,  0.16023f},
    { 0.96136f,  0.00000f,  0.16023f}, { 0.96136f, -0.53836f,  0.16023f},
    { 0.53836f, -0.96136f,  0.16023f}, { 0.00000f, -0.96136f,  0.16023f},
    { 1.44205f,  0.00000f,  0.96136f}, { 1.44205f, -0.80755f,  0.96136f},
    { 0.80755f, -1.44205f,  0.96136f}, { 0.00000f, -1.44205f,  0.96136f},
    { 1.44205f,  0.00000f,  1.92273f}, { 1.44205f, -0.80755f,  1.92273f},
    { 0.80755f, -1.44205f,  1.92273f}, { 0.00000f, -1.44205f,  1.92273f},
    { 1.92273f,  0.00000f,  0.16023f}, { 1.92273f, -1.07673f,  0.16023f},
    { 1.07673f, -1.92273f,  0.16023f}, { 0.00000f, -1.92273f,  0.16023f},
    { 2.56364f,  0.00000f,  0.48068f}, { 2.56364f, -1.43564f,  0.48068f},
    { 1.43564f, -2.56364f,  0.48068f}, { 0.00000f, -2.56364f,  0.48068f},
    { 3.20455f,  0.00000f,  0.48068f}, { 3.20455f, -1.79455f,  0.48068f},
    { 1.79455f, -3.20455f,  0.48068f}, { 0.00000f, -3.20455f,  0.48068f},
    { 3.52500f,  0.00000f,  0.48068f}, { 3.52500f, -1.97400f,  0.48068f},
    { 1.97400f, -3.52500f,  0.48068f}, { 0.00000f, -3.52500f,  0.48068f},
    { 3.52500f,  0.00000f,  0.32045f}, { 3.52500f, -1.97400f,  0.32045f},
    { 1.97400f, -3.52500f,  0.32045f}, { 0.00000f, -3.52500f,  0.32045f},
    { 3.20455f,  0.00000f,  0.32045f}, { 3.20455f, -1.79455f,  0.32045f},
    { 1.79455f, -3.20455f,  0.32045f}, { 0.00000f, -3.20455f,  0.32045f},
    { 2.56364f,  0.00000f,  0.32045f}, { 2.56364f, -1.43564f,  0.32045f},
    { 1.43564f, -2.56364f,  0.32045f}, { 0.00000f, -2.56364f,  0.32045f},
    { 1.92273f,  0.00000f,  0.00000f}, { 1.92273f, -1.07673f,  0.00000f},
    { 1.07673f, -1.92273f,  0.00000f}, { 0.00000f, -1.92273f,  0.00000f},
    { 1.12159f,  0.00000f,  0.00000f}, { 1.12159f, -0.62809f,  0.00000f},
    { 0.62809f, -1.12159f,  0.00000f}, { 0.00000f, -1.12159f,  0.00000f},
    {-1.60227f,  0.00000f,  2.48352f}, {-1.60227f, -0.16023f,  2.48352f},
    {-1.60227f, -0.16023f,  2.72386f}, {-1.60227f,  0.00000f,  2.72386f},
    {-2.72386f,  0.00000f,  3.04432f}, {-2.72386f, -0.16023f,  3.04432f},
    {-2.88409f, -0.16023f,  3.36477f}, {-2.88409f,  0.00000f,  3.36477f},
    {-2.72386f,  0.00000f,  1.84261f}, {-2.72386f, -0.16023f,  1.84261f},
    {-3.20455f, -0.16023f,  1.68239f}, {-3.20455f,  0.00000f,  1.68239f},
    {-1.44205f,  0.00000f,  1.28182f}, {-1.44205f, -0.16023f,  1.28182f},
    {-1.44205f, -0.16023f,  1.04148f}, {-1.44205f,  0.00000f,  1.04148f}
};

#define GLUT_TEASPOON_N_INPUT_PATCHES 16
static int patchdata_teaspoon[GLUT_TEASPOON_N_INPUT_PATCHES][16] =
{
    {  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  13,  12, },
    {  3,  14,  15,  16,   7,  17,  18,  19,  11,  20,  21,  22,  12,  23,  24,  25, },
    { 26,  27,  28,   0,  29,  30,  31,   4,  32,  33,  34,   8,  25,  24,  23,  12, },
    { 16,  35,  36,  26,  19,  37,  38,  29,  22,  39,  40,  32,  25,  41,  41,  25, },
    { 42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,   0,   1,   2,   3, },
    { 45,  54,  55,  56,  49,  57,  58,  59,  53,  60,  61,  62,   3,  14,  15,  16, },
    { 56,  63,  64,  65,  59,  66,  67,  68,  62,  69,  70,  71,  16,  35,  36,  26, },
    { 65,  72,  73,  42,  68,  74,  75,  46,  71,  76,  77,  50,  26,  27,  28,   0, },
    { 78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  42,  43,  44,  45, },
    { 81,  90,  91,  92,  85,  93,  94,  95,  89,  96,  97,  98,  45,  54,  55,  56, },
    { 92,  99, 100, 101,  95, 102, 103, 104,  98, 105, 106, 107,  56,  63,  64,  65, },
    {101, 108, 109,  78, 104, 110, 111,  82, 107, 112, 113,  86,  65,  72,  73,  42, },
    {114, 115, 116, 116, 117, 118, 119, 120, 121, 122, 123, 124,  78,  79,  80,  81, },
    {116, 116, 125, 125, 120, 126, 127, 128, 124, 129, 130, 131,  81,  90,  91,  92, },
    {125, 125, 132, 132, 128, 133, 134, 135, 131, 136, 137, 138,  92,  99, 100, 101, },
    {132, 132, 139, 114, 135, 140, 141, 117, 138, 142, 143, 121, 101, 108, 109,  78  }
};

static GLfloat cpdata_teaspoon[][3] =
{
    {-0.37768f,  0.00000f, -0.06295f}, {-0.15737f,  0.00000f, -0.31473f},
    { 0.15737f,  0.00000f, -0.31473f}, { 0.37768f,  0.00000f, -0.06295f},
    {-0.37768f,  0.33573f, -0.06295f}, {-0.15737f,  0.33573f, -0.31473f},
    { 0.15737f,  0.33573f, -0.31473f}, { 0.37768f,  0.33573f, -0.06295f},
    {-0.18884f,  0.72388f,  0.00000f}, {-0.07851f,  0.62946f, -0.18834f},
    { 0.07851f,  0.62946f, -0.18834f}, { 0.18884f,  0.72388f,  0.00000f},
    {-0.00000f,  0.72388f,  0.00000f}, { 0.00000f,  0.69241f, -0.06295f},
    { 0.43276f,  0.00000f,  0.00000f}, { 0.50357f,  0.00000f,  0.01574f},
    { 0.44062f,  0.00000f, -0.06295f}, { 0.43276f,  0.33573f,  0.00000f},
    { 0.50357f,  0.33573f,  0.01574f}, { 0.44062f,  0.33573f, -0.06295f},
    { 0.21642f,  0.74749f,  0.04708f}, { 0.25179f,  0.77896f,  0.05508f},
    { 0.22031f,  0.75536f,  0.00000f}, { 0.00000f,  0.73175f,  0.01574f},
    { 0.00000f,  0.76323f,  0.01574f}, { 0.00000f,  0.75536f,  0.00000f},
    {-0.44062f,  0.00000f, -0.06295f}, {-0.50357f,  0.00000f,  0.01574f},
    {-0.43276f,  0.00000f,  0.00000f}, {-0.44062f,  0.33573f, -0.06295f},
    {-0.50357f,  0.33573f,  0.01574f}, {-0.43276f,  0.33573f,  0.00000f},
    {-0.22031f,  0.75536f,  0.00000f}, {-0.25179f,  0.77896f,  0.05508f},
    {-0.21642f,  0.74749f,  0.04708f}, { 0.18884f,  0.00000f, -0.37768f},
    {-0.18884f,  0.00000f, -0.37768f}, { 0.18884f,  0.33573f, -0.37768f},
    {-0.18884f,  0.33573f, -0.37768f}, { 0.09442f,  0.66094f, -0.22031f},
    {-0.09442f,  0.66094f, -0.22031f}, { 0.00000f,  0.72388f, -0.06295f},
    {-0.04721f, -0.88125f,  0.18884f}, {-0.01966f, -0.88125f,  0.18884f},
    { 0.01966f, -0.88125f,  0.18884f}, { 0.04721f, -0.88125f,  0.18884f},
    {-0.04721f, -0.56652f,  0.13638f}, {-0.01966f, -0.56652f,  0.13638f},
    { 0.01966f, -0.56652f,  0.13638f}, { 0.04721f, -0.56652f,  0.13638f},
    {-0.37768f, -0.50357f, -0.06295f}, {-0.15737f, -0.50357f, -0.31473f},
    { 0.15737f, -0.50357f, -0.31473f}, { 0.37768f, -0.50357f, -0.06295f},
    { 0.05410f, -0.88125f,  0.18884f}, { 0.06295f, -0.88125f,  0.16327f},
    { 0.05508f, -0.88125f,  0.15737f}, { 0.05410f, -0.56652f,  0.13638f},
    { 0.06295f, -0.56652f,  0.11081f}, { 0.05508f, -0.56652f,  0.10491f},
    { 0.43276f, -0.50357f,  0.00000f}, { 0.50357f, -0.50357f,  0.01574f},
    { 0.44062f, -0.50357f, -0.06295f}, { 0.02360f, -0.88125f,  0.13376f},
    {-0.02753f, -0.88125f,  0.12589f}, {-0.05508f, -0.88125f,  0.15737f},
    { 0.02360f, -0.56652f,  0.08130f}, {-0.02753f, -0.56652f,  0.07343f},
    {-0.05508f, -0.56652f,  0.10491f}, { 0.18884f, -0.50357f, -0.37768f},
    {-0.18884f, -0.50357f, -0.37768f}, {-0.44062f, -0.50357f, -0.06295f},
    {-0.06196f, -0.88125f,  0.16523f}, {-0.05410f, -0.88125f,  0.18884f},
    {-0.06196f, -0.56652f,  0.11277f}, {-0.05410f, -0.56652f,  0.13638f},
    {-0.50357f, -0.50357f,  0.01574f}, {-0.43276f, -0.50357f,  0.00000f},
    {-0.15737f, -3.02143f,  0.12589f}, {-0.03147f, -3.02143f,  0.15737f},
    { 0.03147f, -3.02143f,  0.15737f}, { 0.15737f, -3.02143f,  0.12589f},
    {-0.15737f, -2.39196f,  0.18884f}, {-0.03147f, -2.39196f,  0.22031f},
    { 0.03147f, -2.39196f,  0.22031f}, { 0.15737f, -2.39196f,  0.18884f},
    {-0.04721f, -1.63648f,  0.31473f}, {-0.01966f, -1.63648f,  0.31473f},
    { 0.01966f, -1.63648f,  0.31473f}, { 0.04721f, -1.63648f,  0.31473f},
    { 0.18884f, -3.02143f,  0.11802f}, { 0.18884f, -3.02143f,  0.05508f},
    { 0.15737f, -3.02143f,  0.06295f}, { 0.18884f, -2.39196f,  0.18097f},
    { 0.18884f, -2.39196f,  0.11802f}, { 0.15737f, -2.39196f,  0.12589f},
    { 0.05410f, -1.63661f,  0.31473f}, { 0.06295f, -1.63648f,  0.28916f},
    { 0.05508f, -1.63648f,  0.28326f}, { 0.03147f, -3.02143f,  0.09442f},
    {-0.03147f, -3.02143f,  0.09442f}, {-0.15737f, -3.02143f,  0.06295f},
    { 0.03147f, -2.39196f,  0.15737f}, {-0.03147f, -2.39196f,  0.15737f},
    {-0.15737f, -2.39196f,  0.12589f}, { 0.02360f, -1.63661f,  0.25965f},
    {-0.02753f, -1.63648f,  0.25179f}, {-0.05508f, -1.63648f,  0.28326f},
    {-0.18884f, -3.02143f,  0.05508f}, {-0.18884f, -3.02143f,  0.11802f},
    {-0.18884f, -2.39196f,  0.11802f}, {-0.18884f, -2.39196f,  0.18097f},
    {-0.06196f, -1.63661f,  0.29113f}, {-0.05410f, -1.63661f,  0.31473f},
    {-0.00126f, -3.52500f,  0.06295f}, { 0.00126f, -3.52500f,  0.06295f},
    { 0.00000f, -3.52500f,  0.06295f}, {-0.19010f, -3.52374f,  0.06295f},
    { 0.00126f, -3.52374f,  0.06295f}, { 0.00000f, -3.52374f,  0.06295f},
    { 0.18884f, -3.52374f,  0.06295f}, {-0.15737f, -3.27321f,  0.10071f},
    {-0.03147f, -3.27321f,  0.13219f}, { 0.03147f, -3.27321f,  0.13219f},
    { 0.15737f, -3.27321f,  0.10071f}, { 0.00126f, -3.52500f,  0.00000f},
    { 0.23605f, -3.52374f,  0.06295f}, { 0.23731f, -3.52374f,  0.00000f},
    { 0.19010f, -3.52374f,  0.00000f}, { 0.18884f, -3.27321f,  0.09285f},
    { 0.18884f, -3.27321f,  0.02990f}, { 0.15737f, -3.27321f,  0.03777f},
    {-0.00126f, -3.52500f,  0.00000f}, { 0.00126f, -3.52374f,  0.00000f},
    {-0.00126f, -3.52374f,  0.00000f}, {-0.19010f, -3.52374f,  0.00000f},
    { 0.03147f, -3.27321f,  0.06924f}, {-0.03147f, -3.27321f,  0.06924f},
    {-0.15737f, -3.27321f,  0.03777f}, {-0.00189f, -3.52500f,  0.06295f},
    {-0.23731f, -3.52374f,  0.00000f}, {-0.23794f, -3.52374f,  0.06295f},
    {-0.18884f, -3.27321f,  0.02990f}, {-0.18884f, -3.27321f,  0.09285f}
};

#endif  /* FREEGLUT_TEAPOT_DATA_H */
