/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.node.AnyBoxedNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.NodeList;
import nts.node.SizesEvaluator;
import nts.node.TreatBox;
import nts.node.VBoxNode;
import nts.node.VertIterator;
import nts.typo.TypoCommand;
import nts.typo.VBoxGroup;

public class VTopGroup
extends VBoxGroup {
    public static final VTopPacker packer = new VTopPacker();

    protected Box makeBox(NodeList list) {
        return packer.packVTop(list, this.size, this.exactly, this.maxDepth);
    }

    public VTopGroup(Dimen size, boolean exactly, TreatBox proc) {
        super(size, exactly, proc);
    }

    public static class VTopPacker
    extends TypoCommand.VBoxPacker {
        public VBoxNode packVTop(NodeList list, Dimen desired, boolean exactly, Dimen maxDepth) {
            SizesEvaluator pack = new SizesEvaluator();
            VertIterator.summarize(list.nodes(), pack);
            if (maxDepth != null) {
                pack.restrictDepth(maxDepth);
            }
            Dimen size = pack.getBody().plus(pack.getHeight());
            boolean empty = list.isEmpty();
            if (exactly) {
                pack.evaluate(desired.minus(size), empty);
                size = desired;
            } else {
                pack.evaluate(desired, empty);
                size = size.plus(desired);
            }
            BoxSizes sizes = new BoxSizes(size, pack.getWidth(), pack.getDepth(), pack.getLeftX());
            VBoxNode vbox = new VBoxNode(sizes, pack.getSetting(), list);
            if (this.check(pack)) {
                this.reportBox(vbox);
            }
            Dimen height = pack.getHeight();
            if (!list.isEmpty() && !(list.nodeAt(0) instanceof AnyBoxedNode)) {
                height = Dimen.ZERO;
            }
            sizes = new BoxSizes(height, pack.getWidth(), size.minus(height).plus(pack.getDepth()), pack.getLeftX());
            VBoxNode vtop = new VBoxNode(sizes, pack.getSetting(), list);
            return vtop;
        }
    }
}

