/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* ENV.H --- Definitions for the GUI environment. */
  
enum {

env_start_button       = bLEFT,
env_cont_button        = bMIDDLE,
env_oval_rad           = 1000,
env_dash_len           = 200,
env_graphic_ptr        = bit(cHAIRS),

};

#define MAX_TEXT 500

void handle_pick(EVENT e);
void handle_unpick(EVENT e);
void handle_copy(EVENT e);
void handle_move(EVENT e);
void handle_delete(EVENT e);
void handle_line(EVENT e);
void handle_vector(EVENT e);
void handle_modify(EVENT e);
void handle_rect(EVENT e);
void handle_dashrect(EVENT e);
void handle_fillrect(EVENT e);
void handle_circle(EVENT e);
void handle_fillcircle(EVENT e);
void handle_oval(EVENT e);
void handle_oval2(EVENT e);
void handle_oval4(EVENT e);
void handle_origin(EVENT e);
void handle_zoom(EVENT e);
void reset_zoom(void);
void handle_text(EVENT e);

extern CP_REC copy_displacement[];
void handle_repeat_copy(ENV evv);
void handle_cycle_pick(ENV env);
void handle_undo(void);
void handle_change_thickness(EVENT e);
void handle_change_thickness_button(CANVAS c);
void handle_delete_button(CANVAS c);

void env_set_cursor(unsigned mask, ...);

char *get_text(char *init_str);
void set_text(OBJECT box);
void init_env(void);

void do_emergency_save(char *filename);

extern SP  env_unitlength;

void handle_thickness(LINE_THICKNESS *lt);

extern int pick_size, edited_p;
#define clear_pick_buf() (pick_size = 0)
#define edit()           (edited_p = 1)

extern int hjust, vjust;
#define get_hjust() hjust
#define get_vjust() vjust

typedef enum { 
  tsPICK, 
  tsUNPICK, 
  tsCYCLPICK, 
  tsCOPY, 
  tsMOVE, 
  tsDEL, 
  tsMODIFY, 
  tsTEXT,
  tsPOLYLINE,
  tsVECTOR,
  tsRECT,
  tsDASHRECT,
  tsFILLRECT,
  tsOVAL,
  tsOVAL2,
  tsOVAL4,
  tsCIRC,
  tsFILLCIRC,
  tsORIGIN,
  tsZOOM,
  tsUNDO,
  tsCHG_LT,
} TOOL_SELECTOR_BUTTONS;

extern BUTTON_REC tool_selector_buttons[];
extern CANVAS_REC edit_canvas[];
#define pick_all_menu_entry     MenuEntry(pick_menu, 0)
#define clear_pick_menu_entry   MenuEntry(pick_menu, 1)
#define zoom_out_menu_entry     MenuEntry(edit_menu, 1)
#define repeat_copy_menu_entry  MenuEntry(edit_menu, 2)
extern MENU_ENTRY_REC edit_menu_entries[];
