# logfile $main_file$lsuff displayed wit command $logform    
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc logfile {f austext} {

  upvar 1 $austext a

  global vv logform logback logxterm logoptions main_file lsuff pid dirprefix xtermcall
  global xtem_path

  writescr0 $f ""
  set a ""

  if {$dirprefix==""} {set mfile $main_file} else {set mfile [fileName $main_file]} 

  if {$mfile==""} {set a "${a}***** $vv(ea1)\n"; mybell 2; return}

  writescr $f "[datime] $vv(lo1)\n"
  writescr $f "$logxterm $logform $logoptions $mfile$lsuff $logback\n\n"


  if {[file exists $mfile$lsuff]} { 

   if {[file isfile $mfile$lsuff]} {# displaying:

    if {$logform=="cat"} {# cat ---> xtem text display window

     catFile $mfile$lsuff $f absolutely

    } else {

     # "logform" builds its own window (e.g. emacs) or "logform" is called
     # in an xterm window (e.g. vi), depending on variable "logxterm"
     if {$logxterm==""} {
      eval set r [catch "exec $logform $logoptions $mfile$lsuff $logback" m]
     } elseif {($logform=="more")} {# more needs xtermcall!
      eval set r [catch \
       "exec $xtermcall -e $xtem_path/xtem_prog $logform $logoptions $mfile$lsuff $logback" m]
     } else {
      eval set r [catch "exec $logxterm $logform $logoptions $mfile$lsuff $logback" m]
     }
     set pid "$m"

    }

   } else {                                 # is no regular file!

    set a "${a}***** $vv(aus5) \"$mfile$lsuff\"  $vv(aus6)\n"
    mybell 2

   }

  } else {                                 # logfile deosn't exist!

   set a "${a}***** $vv(lo4) \"$mfile$lsuff\" $vv(lo5)\n"

   mybell 2

  }

}
