/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.texlipse.model.ReferenceEntry;

public class BibOutlineContainer {
    private String startName;
    private String endName;
    private String sorting;
    private List childContainers;
    private List childEntries;
    private boolean topLevel;
    public static final String SORTNATURAL = "natural";
    public static final String SORTYEAR = "year";
    public static final String SORTAUTHOR = "author";
    public static final String SORTJOURNAL = "journal";
    public static final String SORTINDEX = "index";
    private static int MAX_PARTITIONSIZE = 15;

    public BibOutlineContainer(List entries, boolean topLevel) {
        this.childEntries = entries;
        this.topLevel = topLevel;
        this.sorting = SORTNATURAL;
    }

    private BibOutlineContainer(List entries, String sName, String eName) {
        this.childEntries = entries;
        this.startName = sName;
        this.endName = eName;
        this.topLevel = false;
    }

    private BibOutlineContainer childCopy(String sorting) {
        BibOutlineContainer newboc = new BibOutlineContainer(new ArrayList(), this.topLevel);
        newboc.sorting = sorting;
        for (ReferenceEntry re : this.childEntries) {
            newboc.childEntries.add(re.copy());
        }
        return newboc;
    }

    public BibOutlineContainer buildAuthorSort() {
        BibOutlineContainer newboc = this.childCopy(SORTAUTHOR);
        newboc.authorSort();
        for (ReferenceEntry re : newboc.childEntries) {
            re.key = String.valueOf(re.author) + "; " + re.key;
        }
        newboc.partition();
        return newboc;
    }

    private void authorSort() {
        ArrayList<ReferenceEntry> copyChildren = new ArrayList<ReferenceEntry>();
        for (ReferenceEntry re : this.childEntries) {
            re.author = re.author.replaceAll("\\\\(.)", "$1");
            String[] authors = re.author.split(" and ");
            int i = 0;
            while (i < authors.length) {
                int pos;
                if (!(authors[i].indexOf(44) != -1 || authors[i].startsWith("{") && authors[i].endsWith("}") || (pos = authors[i].lastIndexOf(32)) == -1)) {
                    authors[i] = String.valueOf(authors[i].substring(pos + 1)) + ", " + authors[i].substring(0, pos);
                }
                authors[i] = authors[i].replaceAll("(^|[^\\\\])(:?\\{|\\})", "$1");
                ++i;
            }
            re.author = authors[0];
            i = 1;
            while (i < authors.length) {
                ReferenceEntry copyRe = new ReferenceEntry(re.key);
                copyRe.position = re.position;
                copyRe.refFile = re.refFile;
                copyRe.author = authors[i];
                copyChildren.add(copyRe);
                ++i;
            }
        }
        this.childEntries.addAll(copyChildren);
        Collections.sort(this.childEntries, new Comparator(){

            public int compare(Object A, Object B) {
                return ((ReferenceEntry)A).author.compareTo(((ReferenceEntry)B).author);
            }
        });
    }

    public BibOutlineContainer buildYearSort() {
        BibOutlineContainer newboc = this.childCopy(SORTYEAR);
        Collections.sort(newboc.childEntries, new Comparator(){

            public int compare(Object A, Object B) {
                return ((ReferenceEntry)A).year.compareTo(((ReferenceEntry)B).year);
            }
        });
        for (ReferenceEntry re : newboc.childEntries) {
            re.key = String.valueOf(re.year) + "; " + re.key;
        }
        newboc.partition();
        return newboc;
    }

    public BibOutlineContainer buildJournalSort() {
        BibOutlineContainer newboc = this.childCopy(SORTJOURNAL);
        Collections.sort(newboc.childEntries, new Comparator(){

            public int compare(Object A, Object B) {
                return ((ReferenceEntry)A).journal.compareTo(((ReferenceEntry)B).journal);
            }
        });
        for (ReferenceEntry re : newboc.childEntries) {
            re.key = String.valueOf(re.journal) + "; " + re.key;
        }
        newboc.partition();
        return newboc;
    }

    public BibOutlineContainer buildIndexSort() {
        BibOutlineContainer newboc = this.childCopy(SORTINDEX);
        Collections.sort(newboc.childEntries, new Comparator(){

            public int compare(Object A, Object B) {
                return ((ReferenceEntry)A).key.compareTo(((ReferenceEntry)B).key);
            }
        });
        newboc.partition();
        return newboc;
    }

    private String differentiatingPrefix(String s1, String s2) {
        int i = 0;
        int shorter = Math.min(s1.length(), s2.length());
        while (i < shorter) {
            if (s1.charAt(i) != s2.charAt(i)) {
                int l = Math.max(4, i + 1);
                return s1.substring(0, l);
            }
            ++i;
        }
        if (s1.length() == i) {
            return s1;
        }
        return s1.substring(0, i + 1);
    }

    public void partition() {
        if (this.childEntries.size() < MAX_PARTITIONSIZE) {
            return;
        }
        int totalPartitions = (int)Math.ceil((double)this.childEntries.size() / (double)MAX_PARTITIONSIZE);
        ArrayList<BibOutlineContainer> bottomContainers = new ArrayList<BibOutlineContainer>();
        ReferenceEntry[] childArray = new ReferenceEntry[this.childEntries.size()];
        this.childEntries.toArray(childArray);
        String prevName = ((ReferenceEntry)this.childEntries.get((int)0)).key;
        String nextName = "...";
        int i = 0;
        while (i < totalPartitions) {
            int partitionSize = Math.min(this.childEntries.size() - MAX_PARTITIONSIZE * i, MAX_PARTITIONSIZE);
            ReferenceEntry[] newChildren = new ReferenceEntry[partitionSize];
            System.arraycopy(childArray, MAX_PARTITIONSIZE * i, newChildren, 0, partitionSize);
            String pre1 = this.differentiatingPrefix(newChildren[0].key, prevName);
            prevName = newChildren[newChildren.length - 1].key;
            nextName = this.childEntries.size() > 0 ? childArray[0].key : "...";
            String pre2 = this.differentiatingPrefix(prevName, nextName);
            BibOutlineContainer boc = new BibOutlineContainer(Arrays.asList(newChildren), pre1, pre2);
            bottomContainers.add(boc);
            ++i;
        }
        while (bottomContainers.size() > MAX_PARTITIONSIZE) {
            ArrayList<BibOutlineContainer> midContainers = new ArrayList<BibOutlineContainer>();
            while (bottomContainers.size() > 0) {
                int partitionEnd = Math.min(bottomContainers.size(), MAX_PARTITIONSIZE);
                ArrayList children = new ArrayList();
                ListIterator liter = bottomContainers.listIterator();
                int j = 0;
                while (j < partitionEnd) {
                    children.add(liter.next());
                    liter.remove();
                    ++j;
                }
                String sName = ((BibOutlineContainer)children.get((int)0)).startName;
                String eName = ((BibOutlineContainer)children.get((int)0)).endName;
                BibOutlineContainer boc = new BibOutlineContainer(children, sName, eName);
                midContainers.add(boc);
            }
            bottomContainers = midContainers;
        }
        this.childContainers = bottomContainers;
        this.childEntries = null;
    }

    public String toString() {
        return String.valueOf(this.startName) + "..." + this.endName;
    }

    public List getChildContainers() {
        return this.childContainers;
    }

    public List getChildEntries() {
        return this.childEntries;
    }

    public String getSorting() {
        return this.sorting;
    }
}

