/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.viewer.TexLaunchConfigurationTab;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PreviewAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    public void run(IAction action) {
        try {
            ILaunchConfigurationType type;
            ILaunchConfiguration config = null;
            IProject project = TexlipsePlugin.getCurrentProject();
            String outputFormat = TexlipseProperties.getProjectProperty((IResource)project, "outputFormat");
            ViewerAttributeRegistry var = new ViewerAttributeRegistry();
            String preferredViewer = var.getPreferredViewer(outputFormat);
            if (preferredViewer == null) {
                BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorOutputFormatNotSet").replaceAll("%s", project.getName()));
                throw new CoreException(TexlipsePlugin.stat("No previewer found for the current output format."));
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type = manager.getLaunchConfigurationType("net.sourceforge.texlipse.viewer.launchConfigurationType"));
            if (configs != null) {
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration c = iLaunchConfigurationArray[n2];
                    if (c.getType().getIdentifier().equals("net.sourceforge.texlipse.viewer.launchConfigurationType") && c.getAttribute("viewerCurrent", "").equals(preferredViewer)) {
                        config = c;
                        break;
                    }
                    ++n2;
                }
            }
            if (config == null) {
                ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, manager.generateUniqueLaunchConfigurationNameFrom("Preview Document in " + preferredViewer));
                workingCopy.setAttribute("viewerCurrent", preferredViewer);
                TexLaunchConfigurationTab tab = new TexLaunchConfigurationTab();
                tab.setDefaults(workingCopy);
                config = workingCopy.doSave();
            }
            DebugUITools.launch(config, (String)"run");
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Launching viewer", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }
}

