/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : textdata.h
--*/
#ifndef __TEXTDATA_H
#define __TEXTDATA_H

class istream;
class ifstream;
class String;
class TextRecord;

#ifndef __OBJECT_H
#include "object.h"
#endif

//#ifndef __STRiNG_H
//#include "string.h"
//#endif

#ifndef LINE_MAX
#define LINE_MAX 256
#endif

/****************************************************************************
  class TextData
--*/

class TextData : public Object
{
    TextRecord* cursor;
    int _eof;
    
    int get();

 protected:     
    istream& is;

 public:
    operator int() const;
    TextRecord& operator ++( POSTFIX_INT );
    virtual void printOn( ostream& ) const
                               { }

    TextData( istream& i );
    ~TextData();
};

//-- class TextData //

/****************************************************************************
  class TextDataFile
--*/

class TextDataFile : public TextData
{
    const char* filename;
    
 public:
    TextDataFile( const char* name );
    ~TextDataFile();
};
//-- class TextDataFile //

/****************************************************************************
  class TextRecord
--*/

class TextRecord : public Object
{
    String& cursor;
    String& line;

    int fieldLength( const String& s );
    int get();

 public:
    operator int() const;
    const char* operator ++( POSTFIX_INT );
//    String operator ++( POSTFIX_INT );
    virtual void printOn( ostream& os ) const;

    TextRecord( const char* s );
    ~TextRecord();
};

#define ZEROTEXTRECORD (TextRecord*)ZERO
#define NOTEXTRECORD (*ZEROTEXTRECORD)

//-- class TextRecord //

#endif // __TEXTDATA_H //
