/* FileInput.h
 *
 * The text to be parsed is broken into fundamental units called tokens.
 * This file defines the Token class.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include <fstream.h>
#include "Token.h"
const MAXFILES = 10;
const MAXPAGES = 100;

class TextFile {
   int valid;                // Is file ready & open for reading, not at EOF?
   int token_on_this_line;
   int linenum;
   char filename[MAXSTRING];
   char token_text[MAXSTRING];
   ifstream current_file;    // The stream pointer from the input file
   int just_got_a_newline;
   int just_got_whitespace;
   int previous_got_whitespace;

   void handle_comment();
 public:
   TextFile(char *);
   ~TextFile();
   void get_token(Token& token);
   int isvalid();
   int match(char *);
   void fatal_error(char *);
   void warning(char *);
   void got_whitespace();
   int whitespace_next();
   int whitespace_prev();
};

class FileInput {
   char filename[MAXSTRING]; // Main LaTeX file to read input from.
   int filenum;
   TextFile *file[MAXFILES];
   void add_pagedir(char *);
   char pspage[MAXSTRING];         // Next pspage to use
   char current_pspage[MAXSTRING]; // Current pspage being used.
   char *pagedir[MAXPAGES];
   int num_pagedirs;

public:   
   ofstream outfile;
   char outfileroot[MAXSTRING];
   int blankline_area;
   int newline_in_this_blankline_area;
   float vspace_in_this_blankline_area;
   float readjust_vspace;
   char outfilename[MAXSTRING];
   int plain_text_output;

   FileInput(int argc, char *argv[]);
   void get_token(Token &token);   // Prepare to parse tokens.
   void include_file(char *);
   void fatal_error(char *);
   void warning(char *);
   void comma_delimiter(int);
   void set_parsing_length(int);
   void use_pspage(char *);
   void force_space();
   void force_start_page();
   void include_file_ps(char *, int);
   void got_whitespace();
   int whitespace_next();
   int whitespace_prev();
};
