% File:          textpos.sl      -*- mode: SLang -*-
%
% Author:        Guido Gonzato, guido.gonzato@univr.it
%
% Description:   this is a module for latex4jed.
%                
% Installation:  copy textpos.sl to $JED_ROOT/lib/latex, or to your
%                LaTeX_Modules_Dir.
%                
% Version:       1.0.0
%
% Last updated:	 7 July 2003

define textpos_template ()
{
  vinsert ("\\documentclass[%s]{article}\n",
	   LaTeX_Article_Default_Options);
  insert ("\\usepackage[absolute]{textpos}\n");
  insert ("% showboxes,noshowtext,absolute,overlay,quiet,verbose\n\n");

  insert ("\\begin{document}\n\n");
  
  insert ("\\setlength{\\TPHorizModule}{10mm}\n");
  insert ("\\setlength{\\TPVertModule}{\\TPHorizModule}\n");
  insert ("\\textblockorigin{10mm}{10mm}\n\n");
  
  insert ("\\begin{textblock}{10}[0.5,0.5](6,7)\n");
  insert_spaces (LaTeX_Indent);
  push_spot ();
  insert ("\n\\end{textblock}\n\n");
  insert ("\\end{document}");
  pop_spot ();
}

$1 = "LaTeX-Mode";
$2 = "Global.M&ode.Mod&ules.textpos";
definekey_reserved ("textpos_template", "tt", $1);
definekey_reserved ("textpos_template", "^T^T", $1);
menu_append_item ($2, "&Template", "textpos_template");

% ----- End of file textpos.sl
