/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.files;

import de.nm.ant.AbstractWorkerTask;
import de.nm.file.XFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class CopySubDirTask
extends AbstractWorkerTask {
    private boolean copydotfiles = false;
    private File destdir;
    private boolean forceOverwrite = false;
    private boolean newer = true;
    private boolean skipfirstsubdir = false;
    private File srcdir;

    public void execute() {
        if (this.destdir == null) {
            throw new BuildException("No destdir set.");
        }
        if (this.srcdir == null) {
            throw new BuildException("No srcdir set.");
        }
        if (this.srcdir.exists() && this.srcdir.isDirectory()) {
            try {
                ArrayList filelist = XFile.copyDirList((File)this.srcdir, (File)this.destdir, (boolean)this.newer, (boolean)this.forceOverwrite, (boolean)this.copydotfiles, (boolean)this.skipfirstsubdir);
                if (filelist.size() > 0) {
                    this.logVerboseHeader(this.srcdir);
                }
                for (XFile.FilePair filePair : filelist) {
                    this.logVerbose(filePair.getSrcFile(), filePair.getDestFile());
                    XFile.createParent((File)filePair.getDestFile());
                    XFile.copy((File)filePair.getSrcFile(), (File)filePair.getDestFile());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.throwBuildException(e);
            }
        }
    }

    public void setCopydotfiles(boolean copydotfiles) {
        this.copydotfiles = copydotfiles;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void setNewer(boolean newer) {
        this.newer = newer;
    }

    public void setSkipfirstsubdir(boolean skipfirstsubdir) {
        this.skipfirstsubdir = skipfirstsubdir;
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }
}

