/*
ͻ
 What's it called: mycnf.e V1.3a                                            
                                                                            
 What does it do:  Defines the configuration constants for EPM              
                   at compile time.                                         
                                                                            
 For possible values for each setting, see the documentation or STDCNF.E.   
                                                                            
                                                                            
 Who and When: Jon Hacker 5/93                                              
                                                                            
ͼ
*/



const
   EXTRA_EX = 1                -- (0) To make room in EPM.EX for everything we need
   HOST_SUPPORT = ''           -- ('STD') Disable host support.
   REXX_SYNTAX_ASSIST = 0      -- (0) Don't include Rexx syntax assist
   E_SYNTAX_ASSIST = 0         -- (1) The product doesn't need E syntax assist!
   P_SYNTAX_ASSIST = 0         -- (1) Don't include Pascal syntax assist
   C_SYNTAX_ASSIST = 0         -- (1) Don't include C syntax assist
   WANT_STACK_CMDS = 'SWITCH'  -- (0) Include this; nice to have
   WANT_ET_COMMAND = 1         -- (1) Include ETPM nice to have.
   WANT_ALL = 1                -- (0) Include this; nice to have
   WANT_LAN_SUPPORT = 0        -- (0) Only include this if want file locking
   CHECK_FOR_LEXAM = 1         -- (0) Give them spell checking if they already have LEXAM.DLL

   MY_DEFAULT_EDIT_OPTIONS = ''  -- ('') I like expanded tabs
   SETSTAY = '?'               -- (0) Enable the STAY comamnd
   WANT_STREAM_MODE = 'SWITCH' -- (0) Enable switching stream mode on and off
   MY_STREAM_MODE = 1          -- (0) Default is to start with it on
   WANT_CUA_MARKING = 'SWITCH' -- (0) Enable switching between CUA and advanced marking
   MY_CUA_marking_switch = 0   -- (0) Start with advanced marking
   SUPPORT_BOOK_ICON = 0       -- (1) No "Book icon" on Options
   ENHANCED_ENTER_KEYS = 1     -- (0) Let users configure each enter key separately
   NO_ESCAPE = 0               -- (0) set to 1 to disable Escape key for command dialog.
   MOUSE_SUPPORT = 1           -- (1) Another way of saving space.
   ENHANCED_PRINT_SUPPORT = 0  -- (0) Set to 1 to allow WYSIWYG printing
   WANT_DBCS_SUPPORT = 0       -- (0) Set to 1 to include support for DBCS
   WANT_BRACKET_MATCHING = 1   -- (0) Set to 1 to include bracket matching code.
   WANT_KEYWORD_HELP = 1       -- (0) Set to 1 to include keyword lookup code.
   WANT_EPM_SHELL = 1          -- (0) Include the function.
   WANT_LONGNAMES = 'SWITCH'   -- (0) Enable switching on longname support
   WANT_PROFILE = 0            -- (0) Disable switching on Rexx profile support
   TOGGLE_ESCAPE = 1           -- (0) Enable toggling Esc to activate command dialog.
   TOGGLE_TAB = 1              -- (0) Enable toggling Tab key to insert a tab character.

   DEFAULT_MARGINS = '1 254 1'  -- (1 254 1) Set default margins to 254 chars.
   ENTER_ACTION = 'STREAM'     -- (ADDLINE) enter splits line at cursor
   INCLUDE_WORKFRAME_SUPPORT = 0 -- (1) omit workframe/2 support
   MENU_LIMIT = 10             -- (0) use ring menu pulldown for less than 10 files
   MY_JOIN_AFTER_WRAP = 1      -- (1) Join wrapped text with teh next line
   MY_MENU_PROMPT = 1          -- (1) Start out with dynamic menu prompts
   WANT_DYNAMIC_PROMPTS = 1    -- (1) Want dynamic menu prompts
   MY_MOUSESTYLE = 2           -- (1) Drag button 1 for char mark
   MY_TWO_SPACES = 1           -- (1) Leave two spaces after sentence.
   PROOF_DIALOG_FIXED = 1      -- (0) Proof dialog wil appear to the right of edit window
   SHOW_MODIFY_METHOD = 'TITLE' -- ('') Add modify text to title bar
   SHOW_MODIFY_TEXT = '   '    -- ('(mod)') Change the modified file symbol to   
   SMARTFILE = 1               -- (0) F4 will not save if no modifications to file.
   SORT_TYPE = ''              -- ('DLL') Omit sort support.
   WANT_DM_BUFFER = 1          -- (0) enable 'recover mark delete' option.
   WANT_DRAW = 0               -- ('F6') Omit DRAW support.
   WANT_EBOOKIE = 0            -- ('DYNALINK') Omit EBOOKIE support
   WANT_MATH = 1               -- ('?') Include math support
   MY_MATCHTAB_ON = 1          -- (0) start with matchtab on

-- TeX stuff

   TEX_SYNTAX_ASSIST = 1       -- (1) Include TeX syntax assist
   TEX_MENU_ALWAYS_ON = 0      -- (0) TeX menu will be greyed out for non-TeX files
   MY_TEX_FILE_TYPE = 'ADR'    -- ('') User defined file name extension to trigger TeX support
   MY_EXPAND_ON = 0            -- (1) Disable syntax assist on start-up
   TEX_MARGINS = '1 80 1'      -- (1 80 1) Set margins to 80 chars for TeX documents.
   TEX_TABS = 4                -- (4) Set tabs to 4 chars for TeX documents.
   TEX_WANT_ACCELERATOR_KEYS  = 0  -- (0) Don't want TeX keyboard accelerators 
   TEX_LATEX_MODE = 0          -- (0) Start with latex mode off.
   TEX_USER_MODE = 0           -- (0) Start with user mode off (if defined in tex.e).
   TEX_LANDSCAPE_MODE = 0      -- (0) Start with landscape mode off.
   TEX_AUTO_DELETE_LOG = 1     -- (1) Start with EPMTeX log file auto-delete option on.
   TEX_AUTO_SAVE_DOC = 1       -- (1) Start with EPMTeX smart save before TeX option on.
   TEX_DEBUG_MODE = 0          -- (0) Start with EPMTeX debug mode off.

define
   DRAGCOLOR = ''              -- (YELLOW + MAGENTAB) This will use .markcolor for the .dragcolor.

compile if defined(BLACK)
define
   HIGHLIGHT_COLOR = Yellow + Magentab  -- ('') Default is no highlight after Locate
   MARKCOLOR                = White + BlackB  -- (BLUE + GREYB)
compile endif

