#!/bin/sh
#
# splitindex installation script
# Copyright (c) Markus Kohm 2013
#
# $Id: install.sh,v 1.10 2013-04-04 13:12:18 mjk Exp $
#
# This file is part of the SplitIndex bundle.
#
# This work may be distributed and/or modified under the conditions of
# the LaTeX Project Public License, version 1.3c of the license.
# The latest version of this license is in
#   http://www.latex-project.org/lppl.txt
# and version 1.3c or later is part of all distributions of LaTeX
# version 2005/12/01 or later and of this work.
#
# This work has the LPPL maintenance status "maintained".
#
# The Current Maintainer and author of this work is Markus Kohm.
#
# The list of all files belongig to the SplitIndex bundle is given in
# in the file `manifest.txt'. Files generated by means of unpacking the
# distribution (using, for example, the docstrip program) or by means
# of compiling them from a source file, for example, from splitindex.c
# or splitindex.java may be distributed at the distributor's discretion.
# However if they are distributed then a copy of the SplitIndex bundle
# must be distributed together with them.
#
# The list of derived (unpacked or compiled) files belongig to the 
# distribution and covered by LPPL is defined by the unpacking scripts 
# (with extension .ins) and the installation script (with name 
# install.sh) which are part of the distribution.
#
# Two often ignorred clauses from LPPL 1.3c you should not ignore:
# ----------------------------------------------------------------
# 2. You may distribute a complete, unmodified copy of the Work as you
#    received it.  Distribution of only part of the Work is considered
#    modification of the Work, and no right to distribute such a Derived
#    Work may be assumed under the terms of this clause.
# 3. You may distribute a Compiled Work that has been generated from a
#    complete, unmodified copy of the Work as distributed under Clause 2
#    above, as long as that Compiled Work is distributed in such a way that
#    the recipients may install the Compiled Work on their system exactly
#    as it would have been installed if they generated a Compiled Work
#    directly from the Work.

if [ -z "$DESTDIR" ]
then
    TEXMFINSTALL=`kpsewhich -var-value=TEXMFLOCAL`
    if ! mkdir -p $TEXMFINSTALL/tex/latex/splitidx
    then
	TEXMFINSTALL=`kpsewhich -var-value=TEXMFHOME`
    fi
else
    [ -z "$TEXMFINSTALL" ] && TEXMFINSTALL="/texmf"
    [ -z "$BINDIR" ] && BINDIR="/bin"
fi

if [ "$1" == "-h" -o "$1" == "--help" ]
then
    cat <<EOF
install.sh
Copyright (c) Markus Kohm 2013

This bash script installs splitidx and splitindex.
The files will be installed into TEXMF tree 
$DESTDIR$TEXMFINSTALL/.
EOF
    echo -n 'Binaries will be installed to '
    if [ -z "$BINDIR" ]
    then
	find `kpsewhich -var-value=SELFAUTODIR` -mindepth 1 -type d -print
    else
	echo "$DESTDIR$BINDIR/"
    fi
    cat <<EOF
You may change installation paths by setting environment variables DESTDIR, 
TEXMFINSTALL and BINDIR.
EOF
    exit 0
fi

perlavailable=false
if type perl
then 
    perlavailable=true
fi

set -e

sourcedir=`find ./ -name splitidx.dtx`
sourcedir=${sourcedir%/*}/

pushd $sourcedir

tex splitidx.ins

pdflatex -draftmode -interaction=batchmode splitidx.dtx
pdflatex -draftmode -interaction=batchmode splitidx.dtx
mkindex splitidx.dtx
pdflatex -interaction=batchmode splitidx.dtx

mkdir -p "$DESTDIR$TEXMFINSTALL/tex/latex/splitidx"
mkdir -p "$DESTDIR$TEXMFINSTALL/tex/generic/splitindex"
mkdir -p "$DESTDIR$TEXMFINSTALL/scripts/splitindex"
mkdir -p "$DESTDIR$TEXMFINSTALL/doc/latex/splitidx"
mkdir -p "$DESTDIR$TEXMFINSTALL/doc/man/man1"
mkdir -p "$DESTDIR$TEXMFINSTALL/source/latex/splitindex"

install -v -m 644 splitidx.sty "$DESTDIR$TEXMFINSTALL/tex/latex/splitidx/"
install -v -m 644 splitindex.tex "$DESTDIR$TEXMFINSTALL/tex/generic/splitindex/"
install -v -m 755 splitindex.pl splitindex.tlu splitindex_main.tlu \
    "$DESTDIR$TEXMFINSTALL/scripts/splitindex"
install -v -m 644 README splitidx.pdf \
    "$DESTDIR$TEXMFINSTALL/source/latex/splitindex/"
install -v -m 644 splitindex.1 "$DESTDIR$TEXMFINSTALL/doc/man/man1/"

install -v -m 644 README install.txt manifest.txt \
    splitidx.dtx splitidx.ins \
    splitindex.1 splitindex.c splitindex.java splitindex.pl splitindex.tex \
    splitindex.tlu splitindex_main.tlu \
    "$DESTDIR$TEXMFINSTALL/source/latex/splitindex/"

if $perlavailable
then
    cp splitindex.pl splitindex
else
    cp splitindex.tlu splitindex
fi

if [ -z "$BINDIR" ]
then
    find `kpsewhich -var-value=SELFAUTODIR` -mindepth 1 -type d -print0 | \
	xargs -0 install -v -m 755 splitindex
else
    install -v -m 755 splitindex "$DESTDIR$BINDIR/"
fi

rm splitindex

popd
