# NovaBeamer Theme

**Version 1.0**  
*Release Date: April 1, 2025*

The **NovaBeamer Theme** is a LaTeX Beamer theme designed to create elegant and professional presentations for academic and scientific purposes.

## Features

- **Customizable Color Schemes:** Easily adjust the theme's colors to match your institution's branding.
- **Modern Design:** Clean and minimalistic slide layouts that focus on content.
- **Title Page Customization:** Enhanced title page with options for background images and custom formatting.

## Installation

To install the NovaBeamer theme:

1. **Download the Package:**
   - Clone the repository or download the ZIP file from the [GitHub repository](https://github.com/Riccardo-Martelli/NovaBeamer-Theme).

2. **Extract Files:**
   - Extract the contents to your local LaTeX directory or the directory containing your presentation.

3. **Update LaTeX Database:**
   - If you've placed the theme in your local TeX tree, update the filename database using:
     ```sh
     texhash
     ```

## Usage

To use the NovaBeamer theme in your presentation, include the following in the preamble of your `.tex` document:

```latex
\documentclass{beamer}
\usetheme{novabeamer}
```

## Documentation

Detailed documentation is available in the compiled PDF file:
- **Documentation:** `doc/novabeamer-doc.pdf`

This document provides an in-depth guide on customizing and utilizing the NovaBeamer theme to its full potential, along with examples and explanations of key features.

## License

This project is released under the **LaTeX Project Public License (LPPL-1.3c)**, allowing modification and redistribution under its terms. For more details, see the [LICENSE](./LICENSE) file.

## Author

Developed by Riccardo Martelli. For feedback, suggestions, or contributions, please visit the [GitHub repository](https://github.com/Riccardo-Martelli/NovaBeamer-Theme).

## Additional Information

- **Examples:** Additional example files and images are provided in the `examples/` directory to help you get started quickly.


