%%% ====================================================================
%%%  @LaTeX3-style{ LaTeX3-LTX-MS-002,
%%%  filename        = "l3ms002.cls",
%%%  archived        = "ctan:/tex-archive/info/ltx3pub/",
%%%  doc-group       = "Documentation styles",
%%%  title           = "Document class for contributed documents",
%%%  version         = "1.07",
%%%  date            = "08 December 1994",
%%%  time            = "16:45:48 GMT",
%%%  status          = "public, preliminary",
%%%  project-address = "LaTeX3 Project            \\
%%%                     c/o Dr. Chris Rowley      \\
%%%                     The Open University       \\
%%%                     Parsifal College          \\
%%%                     Finchley Road             \\
%%%                     London NW3 7BG, UK",
%%%  project-tel     = "+44 171 794 0575",
%%%  project-FAX     = "+44 171 433 6196",
%%%  project-email   = "LTX3-Mgr@SHSU.edu",
%%%  copyright       = "Copyright (C) 1993 LaTeX3 Project.
%%%                     All rights reserved.
%%%
%%%                     Permission is granted to make and distribute
%%%                     verbatim copies of this style file.
%%%
%%%                     No other permissions to copy or distribute
%%%                     this style in any form are granted.",
%%%
%%%  generalinfo     = "To subscribe to the LaTeX3 discussion list:
%%%
%%%                      Send mail to listserv@vm.urz.uni-heidelberg.de
%%%                      with the following line as the body of the
%%%                      message (substituting your own name):
%%%
%%%                        subscribe LaTeX-L First-name Surname
%%%
%%%                     To find out about volunteer work:
%%%
%%%                      look at the document vol-task.tex which can
%%%                      be obtained electronically, see below.
%%%
%%%                     To retrieve project publications electronically:
%%%
%%%                      Project publications are available for
%%%                      retrieval by anonymous ftp from ctan hosts:
%%%                          ftp.tex.ac.uk
%%%                          ftp.dante.de
%%%                          ftp.shsu.edu
%%%                      in the directory /tex-archive/info/ltx3pub.
%%%
%%%                      The file ltx3pub.bib in that directory gives
%%%                      full bibliographical information including
%%%                      abstracts in BibTeX format.  A brief history
%%%                      of the project and a description of its aims
%%%                      is contained in l3d001.tex.
%%%
%%%                     If you only have access to email, and not ftp
%%%                      You may use the ftpmail service.
%%%                      Send a message just containg the word
%%%                          help
%%%                      to ftpmail@ftp.shsu.edu
%%%                      for more information about this service.
%%%
%%%                     For offers of financial contributions or
%%%                      contributions of computing equipment or
%%%                      software, contact the project at the above
%%%                      address, or the TeX Users Group.
%%%
%%%                     For offers of technical assistance, contact the
%%%                      project at the above address.
%%%
%%%                     For technical enquiries and suggestions, send
%%%                      e-mail to the latex-l list or contact the
%%%                      project at the above address.",
%%%  checksum        = "24204 391 1168 12744",
%%%  docstring       = "The checksum field above contains a CRC-16
%%%                     checksum as the first value, followed by the
%%%                     equivalent of the standard UNIX wc (word
%%%                     count) utility output of lines, words, and
%%%                     characters.  This is produced by Robert
%%%                     Solovay's checksum utility.",
%%%  }
%%% ====================================================================

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{l3ms002}[1994/09/27 LaTeX3 project class report]

\DeclareOption{11pt}
   {\typeout{^^J*** Size option 11pt ignored ***^^J}}
\DeclareOption{12pt}
   {\typeout{^^J*** Size option 12pt ignored ***^^J}}

\DeclareOption*{%
    \PassOptionsToClass{\CurrentOption}{report}}

\ProcessOptions

\LoadClass{report}

\listfiles


% These need visual checking for A4 and US paper: CAR.
\addtolength\topmargin{-1.5cm}
\setlength\textheight{51\baselineskip}
\addtolength\textheight{\topskip}

% Horizontal placement may also need adjustment to look OK on A4 also,
%   (not forgetting space for Chris' marginals on the right): CAR.
\addtolength\textwidth{1cm}
\addtolength\oddsidemargin{-1.5cm}

\let\pagestyle\@gobble
\let\thispagestyle\@gobble


\newcommand\HeaderFont{\fontfamily{cmss}\small}
\newcommand\FooterHeadFont{\fontfamily{cmss}\selectfont}
\newcommand\FooterFont{\small}
\newcommand\DocDetailsFont{\normalsize}
\newcommand\GenInfoFont{\small}



\def\ps@latexthree{%
\def\@oddhead{%
    \parbox\textwidth{%
    \def\FHnewline {\space\ignorespaces}%
    \hbox to\textwidth{\HeaderFont \LaTeX3 Project Document:
                       \FHuse{status}\hfil \thepage}%
    \vskip4pt
    \hrule}}%
%
\let\@evenhead=\@oddhead
%
\def\@oddfoot{%
  \parbox[t]\textwidth{%
    \def\FHnewline {\space\ignorespaces}%
    \FooterFont
    \hrule
    \vskip 2mm
    \hbox to\textwidth{{\FooterHeadFont Title:}
                        \FHuse{title}\quad \hfil
                        {\FooterHeadFont Version:} \FHuse{version}}%
    \hbox to\textwidth{{\FooterHeadFont Author:}
                        \FHuse{author}\quad \hfil}}}%
%
\let\@evenfoot=\@oddfoot
\headheight 16pt
\footskip \baselineskip
}


% *****************
% Cover page stuff:
% *****************

\def \FHmissing   {$*$To be supplied by \LaTeX3 project$*$}

\catcode`\-=11

\let \FHcopyyear      \FHmissing
\let \FHcopyright     \FHmissing
\let \FHcopyleft      \FHmissing
\def \FHproject-email {LTX3-Mgr@SHSU.edu}
\def \FHproject-FAX   {+44 171 433 6196}
\def \FHproject-tel   {+44 171 794 0575}
\def \FHproject-address {\LaTeX3 Project           \\
                         c/o Dr. Chris Rowley      \\
                         The Open University       \\
                         Parsifal College          \\
                         Finchley Road             \\
                         London NW3 7BG, England, UK}
\def \FHkeywords {}
\def \FHauthor-address {}
\def \FHauthor-email   {}
\let \FHstatus    \FHmissing
\let \FHtime      \FHmissing
\let \FHdate      \FHmissing
\let \FHversion   \FHmissing
\let \FHtitle     \FHmissing
\def \FHabstract  {}
\let \FHdoc-group \FHmissing
\let \FHauthor    \FHmissing
\let \FHarchived  \FHmissing
\let \FHfilename  \FHmissing

\catcode`\-=12



% Needs changing so that it will not crash if there is no header
%  or even no checksum entry: CAR.
{\obeylines%
 \long\gdef\FHfield#1
  #2 = "#3"#4,{%
    \global\@namedef{FH#2}{#3}%
    \def\temp{#2}\ifx\temp\chksum\else\expandafter\FHfield\fi}%
% def of ^^M needs to be local! FMi
 \gdef\FHuse#1{{\obeylines\def^^M{\FHnewline}\csname FH#1\endcsname}}%
}%

\def \FHnewline{ \ignorespaces}

\def\chksum{checksum}

\@namedef{LaTeX3-report}{%
  \catcode`\@=12
  \catcode`\-=12
  \catcode`\3=12
  \FHparse}

\long\def\FHparse#1{\FHfield#1\endinput}

\begingroup
  \let\input=\@@input
  \catcode`\%=9
  \catcode`\-=11
  \catcode`\3=11
  \catcode`\@=0
  \setbox0=\hbox{\obeylines
       \input \jobname.tex }
\endgroup

\def\parse@copyright#1(C) #2 #3Project#4All rights reserved.#5\@nil
  {\def\FHcopyyear{#2}%
   \def\FHcopyright{#4}%
   \def\FHcopyleft{#5}}

\ifx\FHcopyright\FHmissing
\else
  \expandafter\parse@copyright\FHcopyright\@nil
\fi



\AtBeginDocument{\set@first@page\ps@latexthree}



\newdimen \widewidth
\setlength\widewidth{1.4\textwidth}

\def\set@first@page{%
\ps@empty
\begin{titlepage}
\emergencystretch=2cm
\moveleft 1.5cm
\hbox to \textwidth
\bgroup
\vbox
\bgroup
\def\and{and }%
\vskip -2cm
\hbox to \widewidth{\sf \LaTeX3 Project Document:
                    \FHstatus\quad \hfil Cover Sheet}
  \vskip 4pt
  \hrule
  \vskip 12pt
  \def\FHnewline {\space\ignorespaces}%
  \noindent
  \copyright\ \FHuse{copyyear} \LaTeX3 Project\FHuse{copyright}
  All rights reserved.\\[3pt]
  \small     \FHuse{copyleft}
  \vskip 6pt
  \hrule
  \vskip 12pt
\hbox to \widewidth
 \bgroup
 \large \sf
  \parbox{0.65\textwidth}{File Information}%
  \hfill
  \parbox{0.70\textwidth}{General Information}%
 \egroup
\vskip 12pt
\hbox to \widewidth
\bgroup
 \begin{minipage}[t]{0.65\textwidth}
  \DocDetailsFont
  \let \FHnewline \\
\begin{description}
  \raggedright
  \let \\\@empty             % suppress \\ in bib entries
  \item[Filename:] \FHuse{filename}
  \item[Archived at:] \FHuse{archived}
  \item[Author:] \FHuse{author}%
       \expandafter\ifx\csname FHauthor-address\endcsname\@empty
               \else \FHnewline \FHuse{author-address}\fi
    \expandafter\ifx\csname FHauthor-email\endcsname\@empty
    \else \FHnewline[3mm] \FHuse{author-email}\fi
  \item[Document group:] \FHuse{doc-group}
\end{description}
\vskip 3mm
\begin{description}
  \raggedright
  \item[Title:] \FHuse{title}
  \item[Version:] \FHuse{version}
  \item[Date/Time:] \FHuse{date}/\FHuse{time}
  \item[Keywords:] \FHuse{keywords}
\end{description}
\noindent{\bf Abstract:}
    \def\FHnewline {\space\ignorespaces}%
    \small
    \raggedright
    \FHuse{abstract}
    \par
 \end{minipage}

 \hfil

 \begin{minipage}[t]{0.70\textwidth}

  \GenInfoFont
  \raggedright
\begin{description}
 \item[The LaTeX3 Project:]\mbox{}\\
                        c/o Dr Chris Rowley      \\
                        The Open University       \\
                        Parsifal College          \\
                        Finchley Road             \\
                        London NW3 7BG, UK
 \item[Tel:]     \mbox{+44 171 794 0575}
 \item[FAX:]     \mbox{+44 171 433 6196}
 \item[E-mail:]  \mbox{\tt LTX3-Mgr@SHSU.edu}

\item[To subscribe to the \LaTeX3 discussion list:]\mbox{}\\
                         Send mail to
\begin{quote}
  \mbox{\tt listserv@vm.urz.uni-heidelberg.de}
\end{quote}
                         with the following line as the body of the
                         message (substituting your own name):
\begin{quote}
  \mbox{\tt subscribe LaTeX-L First-name Surname}
\end{quote}

\item[To find out about volunteer work:]\mbox{}\\
                         look at the document in the file {\tt
                         vol-task.tex}, which can
                         be obtained electronically (see below).

\item[To get project publications electronically:]\mbox{}\\
                         Project publications are available for
                         anonymous ftp retrieval from ctan hosts
                         ({\tt ftp.shsu.edu}, {\tt ftp.dante.de},
                          {\tt ftp.tex.ac.uk})
                         in the directory
                         {\tt/tex-archive/info/ltx3pub}.

                         The file {\tt ltx3pub.bib} in that
                         directory gives
                         full bibliographical information including
                         abstracts in BibTeX format.\\
                         A brief history
                         of the project and a description of its aims
                         is contained in {\tt l3d001.tex}.

                         You may use the ftpmail service to access these
                         files by mail rather than ftp.
                         Send a message just containg the word\\
                         {\tt help}\\
                         in a mail message to:\\
                         {\tt ftpmail@ftp.shsu.edu}\\
                         for more information about this service.

\item[$\bullet$]For offers of financial contributions or
                         contributions of computing equipment or
                         software, contact the project at one of the
                         above addresses, or the TeX Users Group.

\item[$\bullet$]For offers of technical assistance, contact the
                         project at one of the above addresses.

\item[$\bullet$]For technical enquiries and suggestions, send
                        e-mail to the {\tt LaTeX-L} list (see above)
                        or contact the project by letter or
                        FAX at the address above.
\end{description}
 \end{minipage}%
\egroup   % end of inner \hbox
\vskip 12pt
\hrule
\kern-30pt\kern\z@
\egroup   % end of \vbox
\hss
\egroup   % end of outer \hbox
% Need to check that whole box is not to big for US page: not sure
%  what should be done if it is... CAR.
\end{titlepage}}

\endinput
