/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.resource;

import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.resource.LocaleHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultLocales
implements Locales {
    private final Resources resources;
    private Locale locale;
    private Messages messages;
    private String isoCode;
    private Map<String, Locale> isoLocales;
    private List<Locale> locales;
    private List<String> isoCodes;
    private static final Logger logger = Logger.getLogger(DefaultLocales.class.getName());

    public DefaultLocales(Resources resources) {
        this(resources, Locale.getDefault());
    }

    public DefaultLocales(Resources resources, Locale defaultLocale) {
        block5: {
            this.isoLocales = new LinkedHashMap<String, Locale>();
            this.locales = new ArrayList<Locale>();
            this.isoCodes = new ArrayList<String>();
            this.resources = resources;
            List<String> codes = this.getSupportedLocales();
            if (codes.isEmpty()) break block5;
            Map<String, Locale> available = this.getAvailableLocales(defaultLocale);
            for (String code : codes) {
                String key = code.toUpperCase();
                Locale locale = available.get(key);
                if (locale == null) {
                    key = code.toLowerCase();
                    locale = available.get(key);
                }
                if (locale == null) {
                    logger.warning("No locale for: " + code);
                    continue;
                }
                this.locales.add(locale);
                this.addLocale(this.isoLocales, locale);
                this.isoCodes.add(code);
            }
            if (!(this.locales.isEmpty() || this.changeLocale(defaultLocale.getCountry()) || this.changeLocale(defaultLocale.getLanguage()))) {
                for (String code : codes) {
                    if (this.changeLocale(code)) break;
                }
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String code) {
        if (!this.changeLocale(code)) {
            throw new ResourceNotFoundException("No locale found for code: " + code);
        }
    }

    @Override
    public String getISOCode() {
        return this.isoCode;
    }

    @Override
    public Locale getLocale(String code) {
        Locale locale = this.findByCountry(code);
        if (locale == null) {
            locale = this.findByLanguage(code);
        }
        return locale;
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public List<String> getISOCodes() {
        return this.isoCodes;
    }

    @Override
    public Messages getMessages() {
        if (this.locale == null) {
            throw new ResourceException("No locale set");
        }
        if (this.messages == null) {
            throw new ResourceNotFoundException("Cannot find messages for locale: " + this.locale.getLanguage());
        }
        return this.messages;
    }

    @Override
    public Messages getMessages(String name) {
        InputStream in = this.resources.getInputStream(name);
        return new LocaleDatabase(in, (Locales)this);
    }

    private Map<String, Locale> getAvailableLocales(Locale defaultLocale) {
        HashMap<String, Locale> available = new HashMap<String, Locale>();
        this.addLocale(available, defaultLocale);
        for (Locale locale : Locale.getAvailableLocales()) {
            this.addLocale(available, locale, defaultLocale);
        }
        return available;
    }

    private void addLocale(Map<String, Locale> locales, Locale locale) {
        this.addLocale(locales, locale, null);
    }

    private void addLocale(Map<String, Locale> locales, Locale locale, Locale defaultLocale) {
        String country3;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        Locale existing = locales.get(language);
        if (existing == null || existing != defaultLocale && !"".equals(existing.getCountry()) && "".equals(country)) {
            String language3;
            if (!"".equals(language)) {
                locales.put(language, locale);
            }
            if ((language3 = LocaleHelper.getISO3Language(locale)) != null) {
                locales.put(language3, locale);
            }
        }
        if (!"".equals(country)) {
            locales.put(country, locale);
        }
        if ((country3 = LocaleHelper.getISO3Country(locale)) != null) {
            locales.put(country3, locale);
        }
    }

    private boolean changeLocale(String code) {
        if (code == null || code.equals("")) {
            this.locale = null;
        } else {
            Messages parentMessages = this.messages;
            this.messages = null;
            this.locale = this.findByCountry(code);
            if (this.locale == null) {
                this.locale = this.findByLanguage(code);
            }
            if (this.locale != null) {
                String language;
                InputStream in = null;
                String country = LocaleHelper.getISO3Country(this.locale);
                if (country != null) {
                    in = this.getMessagesStream(country.toLowerCase());
                    this.isoCode = country;
                }
                if (in == null && (language = LocaleHelper.getISO3Language(this.locale)) != null) {
                    in = this.getMessagesStream(language);
                    this.isoCode = language;
                }
                if (in == null) {
                    logger.warning("Cannot find messages for locale: " + code);
                } else {
                    this.messages = new LocaleDatabase(in, parentMessages, this);
                }
            }
        }
        return this.locale != null;
    }

    private InputStream getMessagesStream(String code) {
        InputStream result = null;
        try {
            String path = "langpacks/" + code + ".xml";
            result = this.resources.getInputStream(path);
        }
        catch (ResourceNotFoundException ignore) {
            logger.fine("Locale has no langpack for code: " + code);
        }
        return result;
    }

    private List<String> getSupportedLocales() {
        List locales = null;
        try {
            locales = (List)this.resources.getObject("langpacks.info");
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return locales != null ? locales : Collections.emptyList();
    }

    private Locale findByLanguage(String code) {
        return this.isoLocales.get(code.toLowerCase());
    }

    private Locale findByCountry(String code) {
        return this.isoLocales.get(code.toUpperCase());
    }
}

